/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection.iter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.Chain;

public class IterChain<T>
implements Iterator<T>,
Chain<Iterator<T>, IterChain<T>> {
    protected final List<Iterator<T>> allIterators = new ArrayList<Iterator<T>>();
    protected int currentIter = -1;

    public IterChain() {
    }

    @SafeVarargs
    public IterChain(Iterator<T> ... iterators) {
        if (ArrayUtil.isNotEmpty(iterators)) {
            for (Iterator<T> iterator : iterators) {
                this.addChain(iterator);
            }
        }
    }

    @Override
    public IterChain<T> addChain(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        if (this.allIterators.contains(iterator)) {
            throw new IllegalArgumentException("Duplicate iterator");
        }
        this.allIterators.add(iterator);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIter == -1) {
            this.currentIter = 0;
        }
        int size = this.allIterators.size();
        for (int i = this.currentIter; i < size; ++i) {
            Iterator<T> iterator = this.allIterators.get(i);
            if (!iterator.hasNext()) continue;
            this.currentIter = i;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.allIterators.get(this.currentIter).next();
    }

    @Override
    public void remove() {
        if (-1 == this.currentIter) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this.allIterators.get(this.currentIter).remove();
    }

    @Override
    public Iterator<Iterator<T>> iterator() {
        return this.allIterators.iterator();
    }
}

