/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dromara.hutool.core.convert.AbstractConverter;
import org.dromara.hutool.core.date.CalendarUtil;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.text.StrUtil;

public class CalendarConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private String format;

    public CalendarConverter() {
        this(null);
    }

    public CalendarConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Calendar convertInternal(Class<?> targetClass, Object value) {
        if (value instanceof Date) {
            return CalendarUtil.calendar((Date)value);
        }
        if (value instanceof Long) {
            return CalendarUtil.calendar((Long)value);
        }
        if (value instanceof XMLGregorianCalendar) {
            return CalendarUtil.calendar((XMLGregorianCalendar)value);
        }
        String valueStr = this.convertToStr(value);
        return CalendarUtil.calendar(StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format));
    }
}

