/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.func;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.dromara.hutool.core.stream.StreamUtil;

public class PredicateUtil {
    public static <T> Predicate<T> alwaysTrue() {
        return method -> true;
    }

    static <T> Predicate<T> coerce(Predicate<? super T> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> negate(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> and(Iterable<Predicate<T>> components) {
        return StreamUtil.of(components, false).reduce(Predicate::and).orElseGet(() -> o -> true);
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<T> ... components) {
        return StreamUtil.of(components).reduce(Predicate::and).orElseGet(() -> o -> true);
    }

    public static <T> Predicate<T> or(Iterable<Predicate<T>> components) {
        return StreamUtil.of(components, false).reduce(Predicate::or).orElseGet(() -> o -> false);
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<T> ... components) {
        return StreamUtil.of(components).reduce(Predicate::or).orElseGet(() -> o -> false);
    }

    @SafeVarargs
    public static <T> Predicate<T> none(Predicate<T> ... components) {
        return t -> Stream.of(components).noneMatch(matcher -> matcher.test(t));
    }
}

