/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.watch;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.PathUtil;
import org.dromara.hutool.core.io.watch.WatchException;
import org.dromara.hutool.core.io.watch.WatchKind;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;

public class WatchServiceWrapper
extends SimpleWrapper<WatchService>
implements WatchService,
Serializable {
    private static final long serialVersionUID = 1L;
    private WatchEvent.Kind<?>[] events;
    private WatchEvent.Modifier[] modifiers;
    private boolean isClosed;

    public static WatchServiceWrapper of(WatchEvent.Kind<?> ... events) {
        return new WatchServiceWrapper(events);
    }

    public WatchServiceWrapper(WatchEvent.Kind<?> ... events) {
        super(WatchServiceWrapper.newWatchService());
        this.events = events;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            IoUtil.closeQuietly((AutoCloseable)this.raw);
        }
    }

    @Override
    public WatchKey poll() {
        return ((WatchService)this.raw).poll();
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        return ((WatchService)this.raw).poll(timeout, unit);
    }

    @Override
    public WatchKey take() throws InterruptedException {
        return ((WatchService)this.raw).take();
    }

    public WatchServiceWrapper setEvents(WatchKind ... kinds) {
        if (ArrayUtil.isNotEmpty(kinds)) {
            this.setEvents(ArrayUtil.mapToArray(kinds, WatchKind::getValue, WatchEvent.Kind[]::new));
        }
        return this;
    }

    public WatchServiceWrapper setEvents(WatchEvent.Kind<?> ... events) {
        this.events = events;
        return this;
    }

    public WatchServiceWrapper setModifiers(WatchEvent.Modifier ... modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public WatchKey register(Watchable watchable) {
        WatchKey watchKey;
        block2: {
            WatchEvent.Kind<?>[] kinds = ArrayUtil.defaultIfEmpty(this.events, WatchKind.ALL);
            watchKey = null;
            try {
                watchKey = ArrayUtil.isEmpty(this.modifiers) ? watchable.register((WatchService)this.raw, kinds) : watchable.register((WatchService)this.raw, kinds, this.modifiers);
            }
            catch (IOException e) {
                if (e instanceof AccessDeniedException) break block2;
                throw new WatchException(e);
            }
        }
        return watchKey;
    }

    public WatchServiceWrapper registerPath(Path path, int maxDepth) {
        if (null == this.register(path)) {
            return this;
        }
        PathUtil.walkFiles(path, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                WatchServiceWrapper.this.registerPath(dir, 0);
                return super.postVisitDirectory(dir, exc);
            }
        });
        return this;
    }

    public void watch(Watcher watcher, Predicate<WatchEvent<?>> watchFilter) {
        this.watch((WatchEvent<?> event, WatchKey watchKey) -> {
            WatchEvent.Kind kind = event.kind();
            if (kind == WatchKind.CREATE.getValue()) {
                watcher.onCreate((WatchEvent<?>)event, (WatchKey)watchKey);
            } else if (kind == WatchKind.MODIFY.getValue()) {
                watcher.onModify((WatchEvent<?>)event, (WatchKey)watchKey);
            } else if (kind == WatchKind.DELETE.getValue()) {
                watcher.onDelete((WatchEvent<?>)event, (WatchKey)watchKey);
            } else if (kind == WatchKind.OVERFLOW.getValue()) {
                watcher.onOverflow((WatchEvent<?>)event, (WatchKey)watchKey);
            }
        }, watchFilter);
    }

    public void watch(BiConsumer<WatchEvent<?>, WatchKey> action) {
        this.watch(action, null);
    }

    public void watch(BiConsumer<WatchEvent<?>, WatchKey> action, Predicate<WatchEvent<?>> watchFilter) {
        WatchKey wk;
        try {
            wk = ((WatchService)this.raw).take();
        }
        catch (InterruptedException | ClosedWatchServiceException e) {
            this.close();
            return;
        }
        for (WatchEvent<?> event : wk.pollEvents()) {
            if (null != watchFilter && !watchFilter.test(event)) continue;
            action.accept(event, wk);
        }
        wk.reset();
    }

    private static WatchService newWatchService() {
        try {
            return FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new WatchException(e);
        }
    }
}

