/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.mutable;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.lang.mutable.MutableBool;
import org.dromara.hutool.core.lang.mutable.MutableByte;
import org.dromara.hutool.core.lang.mutable.MutableDouble;
import org.dromara.hutool.core.lang.mutable.MutableFloat;
import org.dromara.hutool.core.lang.mutable.MutableInt;
import org.dromara.hutool.core.lang.mutable.MutableLong;
import org.dromara.hutool.core.lang.mutable.MutableObj;
import org.dromara.hutool.core.lang.mutable.MutableShort;

public interface Mutable<T> {
    public static MutableBool of(boolean value) {
        return new MutableBool(value);
    }

    public static MutableByte of(byte value) {
        return new MutableByte(value);
    }

    public static MutableFloat of(float value) {
        return new MutableFloat(value);
    }

    public static MutableInt of(int value) {
        return new MutableInt(value);
    }

    public static MutableLong of(long value) {
        return new MutableLong(value);
    }

    public static MutableDouble of(double value) {
        return new MutableDouble(value);
    }

    public static MutableShort of(short value) {
        return new MutableShort(value);
    }

    public static <T> MutableObj<T> of(T value) {
        return new MutableObj<T>(value);
    }

    public T get();

    public void set(T var1);

    default public Mutable<T> map(UnaryOperator<T> operator) {
        this.set(operator.apply(this.get()));
        return this;
    }

    default public Mutable<T> peek(Consumer<T> consumer) {
        consumer.accept(this.get());
        return this;
    }

    default public boolean test(Predicate<T> predicate) {
        return predicate.test(this.get());
    }

    default public Opt<T> toOpt() {
        return this.to(Opt::ofNullable);
    }

    default public <R> R to(Function<T, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this.get());
    }
}

