/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.url;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.net.url.RFC3986;
import org.dromara.hutool.core.net.url.UrlEncoder;
import org.dromara.hutool.core.net.url.UrlQuery;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class UrlQueryUtil {
    public static String toQuery(Map<String, ?> paramMap) {
        return UrlQueryUtil.toQuery(paramMap, CharsetUtil.UTF_8);
    }

    public static String toQuery(Map<String, ?> paramMap, Charset charset) {
        return UrlQueryUtil.toQuery(paramMap, charset, null);
    }

    public static String toQuery(Map<String, ?> paramMap, Charset charset, UrlQuery.EncodeMode encodeMode) {
        return UrlQuery.of(paramMap, encodeMode).build(charset);
    }

    public static String encodeQuery(String urlWithParams, Charset charset) {
        String paramPart;
        if (StrUtil.isBlank(urlWithParams)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = urlWithParams.indexOf(63);
        if (pathEndPos > -1) {
            urlPart = StrUtil.subPre(urlWithParams, pathEndPos);
            paramPart = StrUtil.subSuf(urlWithParams, pathEndPos + 1);
            if (StrUtil.isBlank(paramPart)) {
                return urlPart;
            }
        } else {
            if (!StrUtil.contains((CharSequence)urlWithParams, '=')) {
                return urlWithParams;
            }
            paramPart = urlWithParams;
        }
        paramPart = UrlQueryUtil.normalizeQuery(paramPart, charset);
        return StrUtil.isBlank(urlPart) ? paramPart : urlPart + "?" + paramPart;
    }

    public static String normalizeQuery(String queryPart, Charset charset) {
        int lastIndex;
        int i;
        if (StrUtil.isEmpty(queryPart)) {
            return queryPart;
        }
        StringBuilder builder = new StringBuilder(queryPart.length() + 16);
        int len = queryPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = queryPart.charAt(i);
            if (c == '=') {
                if (null != name) continue;
                name = pos == i ? "" : queryPart.substring(pos, i);
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name) {
                if (pos != i) {
                    name = queryPart.substring(pos, i);
                    builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=');
                }
            } else {
                builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=').append(RFC3986.QUERY_PARAM_VALUE.encode(queryPart.substring(pos, i), charset, new char[0])).append('&');
            }
            name = null;
            pos = i + 1;
        }
        if (null != name) {
            builder.append(UrlEncoder.encodeQuery(name, charset)).append('=');
        }
        if (pos != i) {
            if (null == name && pos > 0) {
                builder.append('=');
            }
            builder.append(UrlEncoder.encodeQuery(queryPart.substring(pos, i), charset));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            builder.delete(lastIndex, builder.length());
        }
        return builder.toString();
    }

    public static Map<String, String> decodeQuery(String paramsStr, Charset charset) {
        Map<CharSequence, CharSequence> queryMap = UrlQuery.of(paramsStr, charset).getQueryMap();
        if (MapUtil.isEmpty(queryMap)) {
            return MapUtil.empty();
        }
        return ConvertUtil.toMap(String.class, String.class, queryMap);
    }

    public static Map<String, List<String>> decodeQueryList(String paramsStr, Charset charset) {
        Map<CharSequence, CharSequence> queryMap = UrlQuery.of(paramsStr, charset).getQueryMap();
        if (MapUtil.isEmpty(queryMap)) {
            return MapUtil.empty();
        }
        Console.log(queryMap);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        queryMap.forEach((key, value) -> {
            if (null != key) {
                List values = params.computeIfAbsent(key.toString(), k -> new ArrayList(1));
                values.add(StrUtil.toStringOrNull(value));
            }
        });
        return params;
    }
}

