/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.TripleTable;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.text.StrTrimer;
import org.dromara.hutool.core.text.StrUtil;

public class ClassDescUtil {
    public static final char JVM_VOID = 'V';
    public static final char JVM_BOOLEAN = 'Z';
    public static final char JVM_BYTE = 'B';
    public static final char JVM_CHAR = 'C';
    public static final char JVM_DOUBLE = 'D';
    public static final char JVM_FLOAT = 'F';
    public static final char JVM_INT = 'I';
    public static final char JVM_LONG = 'J';
    public static final char JVM_SHORT = 'S';
    private static final TripleTable<Class<?>, Character, String> PRIMITIVE_TABLE = new TripleTable(9);

    public static Class<?> descToClass(String desc) throws HutoolException {
        return ClassDescUtil.descToClass(desc, true, null);
    }

    public static Class<?> descToClass(String desc, boolean isInitialized, ClassLoader cl) throws HutoolException {
        Assert.notNull(desc, "Name must not be null", new Object[0]);
        char firstChar = desc.charAt(0);
        Class<?> clazz = PRIMITIVE_TABLE.getLeftByMiddle(Character.valueOf(firstChar));
        if (null != clazz) {
            return clazz;
        }
        desc = StrUtil.trim(desc, StrTrimer.TrimMode.SUFFIX, c -> '/' == c.charValue() || '.' == c.charValue());
        if ('L' == firstChar) {
            desc = desc.substring(1, desc.length() - 1);
        }
        return ClassUtil.forName(desc, isInitialized, cl);
    }

    public static String getDesc(Class<?> c) {
        StringBuilder ret = new StringBuilder();
        while (c.isArray()) {
            ret.append('[');
            c = c.getComponentType();
        }
        if (c.isPrimitive()) {
            Character desc = PRIMITIVE_TABLE.getMiddleByLeft(c);
            if (null != desc) {
                ret.append(desc.charValue());
            }
        } else {
            ret.append('L');
            ret.append(c.getName().replace('.', '/'));
            ret.append(';');
        }
        return ret.toString();
    }

    public static String getDesc(Executable methodOrConstructor, boolean appendName) {
        Class<?>[] parameterTypes;
        StringBuilder ret = new StringBuilder();
        if (appendName && methodOrConstructor instanceof Method) {
            ret.append(methodOrConstructor.getName());
        }
        ret.append('(');
        for (Class<?> parameterType : parameterTypes = methodOrConstructor.getParameterTypes()) {
            ret.append(ClassDescUtil.getDesc(parameterType));
        }
        ret.append(')');
        if (methodOrConstructor instanceof Method) {
            ret.append(ClassDescUtil.getDesc(((Method)methodOrConstructor).getReturnType()));
        } else {
            ret.append('V');
        }
        return ret.toString();
    }

    public static String getName(Class<?> c) {
        if (c.isArray()) {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append("[]");
            } while ((c = c.getComponentType()).isArray());
            return c.getName() + sb;
        }
        return c.getName();
    }

    public static String getName(Executable executable) {
        StringBuilder ret = new StringBuilder("(");
        if (executable instanceof Method) {
            ret.append(ClassDescUtil.getName(((Method)executable).getReturnType())).append(' ');
        }
        Class<?>[] parameterTypes = executable.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                ret.append(',');
            }
            ret.append(ClassDescUtil.getName(parameterTypes[i]));
        }
        ret.append(')');
        return ret.toString();
    }

    public static Class<?> nameToClass(String name, boolean isInitialized, ClassLoader cl) {
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = StrUtil.trim(name, StrTrimer.TrimMode.SUFFIX, c -> '/' == c.charValue() || '.' == c.charValue());
        int c2 = 0;
        int index = name.indexOf(91);
        if (index > 0) {
            c2 = (name.length() - index) / 2;
            name = name.substring(0, index);
        }
        if (c2 > 0) {
            StringBuilder sb = new StringBuilder();
            while (c2-- > 0) {
                sb.append('[');
            }
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
            if (null != clazz) {
                sb.append(PRIMITIVE_TABLE.getMiddleByLeft(clazz).charValue());
            } else {
                sb.append('L').append(name).append(';');
            }
            name = sb.toString();
        } else {
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
            if (null != clazz) {
                return clazz;
            }
        }
        return ClassUtil.forName(name, isInitialized, cl);
    }

    public static String nameToDesc(String name) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        int index = name.indexOf(91);
        if (index > 0) {
            c = (name.length() - index) / 2;
            name = name.substring(0, index);
        }
        while (c-- > 0) {
            sb.append('[');
        }
        Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
        if (null != clazz) {
            sb.append(PRIMITIVE_TABLE.getMiddleByLeft(clazz).charValue());
        } else {
            sb.append('L').append(name.replace('.', '/')).append(';');
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String descToName(String desc) {
        StringBuilder sb = new StringBuilder();
        int c = desc.lastIndexOf(91) + 1;
        if (desc.length() == c + 1) {
            char descChar = desc.charAt(c);
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByMiddle(Character.valueOf(descChar));
            if (null == clazz) throw new HutoolException("Unsupported primitive desc: {}", desc);
            sb.append(PRIMITIVE_TABLE.getRightByLeft(clazz));
        } else {
            sb.append(desc.substring(c + 1, desc.length() - 1).replace('/', '.'));
        }
        while (c-- > 0) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static String getCodeBase(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ProtectionDomain domain = clazz.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource source = domain.getCodeSource();
        if (source == null) {
            return null;
        }
        URL location = source.getLocation();
        if (location == null) {
            return null;
        }
        return location.getFile();
    }

    static {
        PRIMITIVE_TABLE.put(Void.TYPE, Character.valueOf('V'), "void");
        PRIMITIVE_TABLE.put(Boolean.TYPE, Character.valueOf('Z'), "boolean");
        PRIMITIVE_TABLE.put(Byte.TYPE, Character.valueOf('B'), "byte");
        PRIMITIVE_TABLE.put(Character.TYPE, Character.valueOf('C'), "char");
        PRIMITIVE_TABLE.put(Double.TYPE, Character.valueOf('D'), "double");
        PRIMITIVE_TABLE.put(Float.TYPE, Character.valueOf('F'), "float");
        PRIMITIVE_TABLE.put(Integer.TYPE, Character.valueOf('I'), "int");
        PRIMITIVE_TABLE.put(Long.TYPE, Character.valueOf('J'), "long");
        PRIMITIVE_TABLE.put(Short.TYPE, Character.valueOf('S'), "short");
    }
}

