/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.method;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.NullWrapperBean;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.map.reference.WeakConcurrentMap;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.method.MethodInvoker;
import org.dromara.hutool.core.reflect.method.MethodReflect;
import org.dromara.hutool.core.stream.StreamUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.BooleanUtil;

public class MethodUtil {
    private static final WeakConcurrentMap<Class<?>, MethodReflect> METHODS_CACHE = new WeakConcurrentMap();

    static synchronized void clearCache() {
        METHODS_CACHE.clear();
    }

    public static Method getMethod(Method[] methods, Predicate<Method> predicate) {
        return ArrayUtil.get(methods, predicate);
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        return StreamUtil.of(MethodUtil.getPublicMethods(clazz)).map(Method::getName).collect(Collectors.toSet());
    }

    public static Method getPublicMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        return MethodUtil.getMethod(MethodUtil.getPublicMethods(clazz), ignoreCase, methodName, paramTypes);
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StrUtil.isBlank(methodName)) {
            return null;
        }
        return MethodUtil.getMethod(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return MethodUtil.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return MethodUtil.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        return MethodUtil.getMethod(MethodUtil.getMethods(clazz), ignoreCase, methodName, paramTypes);
    }

    public static Method getMethod(Method[] methods, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (ArrayUtil.isEmpty(methods) || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || !ClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return MethodUtil.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return MethodUtil.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method[] methods = MethodUtil.getMethods(clazz, method -> StrUtil.equals(methodName, method.getName(), ignoreCase) && method.getReturnType().isAssignableFrom(method.getReturnType()));
        return ArrayUtil.isEmpty(methods) ? null : methods[0];
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        return StreamUtil.of(MethodUtil.getMethods(clazz, null)).map(Method::getName).collect(Collectors.toSet());
    }

    public static Method[] getMethods(Class<?> clazz) throws SecurityException {
        return MethodUtil.getMethods(clazz, null);
    }

    public static Method[] getMethods(Class<?> clazz, Predicate<Method> predicate) throws SecurityException {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getAllMethods(predicate);
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return MethodUtil.getPublicMethods(clazz, null);
    }

    public static Method[] getPublicMethods(Class<?> clazz, Predicate<Method> predicate) {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getPublicMethods(predicate);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) throws SecurityException {
        return MethodUtil.getDeclaredMethods(clazz, null);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz, Predicate<Method> predicate) throws SecurityException {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getDeclaredMethods(predicate);
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        return MethodReflect.of(Assert.notNull(beanClass)).getMethodsDirectly(withSupers, withMethodFromObject);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && MethodUtil.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && MethodUtil.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return MethodUtil.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        int parameterCount = method.getParameterCount();
        switch (parameterCount) {
            case 0: {
                return MethodUtil.isGetter(method, ignoreCase);
            }
            case 1: {
                return MethodUtil.isSetter(method, ignoreCase);
            }
        }
        return false;
    }

    public static boolean isSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (1 != parameterCount) {
            return false;
        }
        String name = method.getName();
        if (name.length() < 4) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        return name.startsWith("set");
    }

    public static boolean isGetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        if (0 != method.getParameterCount()) {
            return false;
        }
        if (Void.class == method.getReturnType()) {
            return false;
        }
        String name = method.getName();
        if (name.length() < 3 || "getClass".equals(name) || "get".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        if (name.startsWith("is")) {
            return BooleanUtil.isBoolean(method.getReturnType());
        }
        return name.startsWith("get");
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws HutoolException {
        return MethodUtil.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws HutoolException {
        return MethodInvoker.of(method).setCheckArgs(true).invoke(obj, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws HutoolException {
        return MethodInvoker.of(method).invoke(obj, args);
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws HutoolException {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = MethodUtil.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new HutoolException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return MethodUtil.invoke(obj, method, args);
    }

    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        return MethodUtil.invoke(classNameWithMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        if (StrUtil.isBlank(classNameWithMethodName)) {
            throw new HutoolException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new HutoolException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return MethodUtil.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return MethodUtil.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class clazz = ClassLoaderUtil.loadClass(className);
        try {
            Method method = MethodUtil.getMethod(clazz, methodName, ClassUtil.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StrUtil.format("No such method: [{}]", methodName));
            }
            if (ModifierUtil.isStatic(method)) {
                return MethodUtil.invoke(null, method, args);
            }
            return MethodUtil.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : ConstructorUtil.newInstance(clazz, new Object[0]), method, args);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapRuntime(e);
        }
    }

    public static Object[] actualArgs(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (1 == parameterTypes.length && parameterTypes[0].isArray()) {
            return args;
        }
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassUtil.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapperBean) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = ConvertUtil.convert(parameterTypes[i], args[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        return actualArgs;
    }
}

