/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text;

import java.util.Arrays;
import org.dromara.hutool.core.text.StrUtil;

public class StrRepeater {
    private final int countOrLength;

    public static StrRepeater of(int countOrLength) {
        return new StrRepeater(countOrLength);
    }

    public StrRepeater(int countOrLength) {
        this.countOrLength = countOrLength;
    }

    public String repeat(char c) {
        int count = this.countOrLength;
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        Arrays.fill(result, c);
        return new String(result);
    }

    public String repeat(CharSequence str) {
        int n;
        if (null == str) {
            return null;
        }
        int count = this.countOrLength;
        if (count <= 0 || str.length() == 0) {
            return "";
        }
        if (count == 1) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public String repeatByLength(CharSequence str) {
        if (null == str) {
            return null;
        }
        int padLen = this.countOrLength;
        if (padLen <= 0) {
            return "";
        }
        int strLen = str.length();
        if (strLen == padLen) {
            return str.toString();
        }
        if (strLen > padLen) {
            return StrUtil.subPre(str, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = str.charAt(i % strLen);
        }
        return new String(padding);
    }

    public String repeatAndJoin(CharSequence str, CharSequence delimiter) {
        int count = this.countOrLength;
        if (count <= 0) {
            return "";
        }
        if (StrUtil.isEmpty(delimiter)) {
            return this.repeat(str);
        }
        StringBuilder builder = new StringBuilder(str.length() * count + delimiter.length() * (count - 1));
        builder.append(str);
        while (true) {
            int n = --count;
            --count;
            if (n <= 0) break;
            builder.append(delimiter).append(str);
        }
        return builder.toString();
    }
}

