/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.thread;

import java.io.Closeable;
import java.io.IOException;
import org.dromara.hutool.core.date.StopWatch;
import org.dromara.hutool.core.thread.SyncFinisher;

public class ConcurrencyTester
implements Closeable {
    private final SyncFinisher sf;
    private final StopWatch timeInterval;
    private long interval;

    public ConcurrencyTester(int threadSize) {
        this.sf = new SyncFinisher(threadSize);
        this.timeInterval = new StopWatch();
    }

    public ConcurrencyTester test(Runnable runnable) {
        this.sf.clearWorker();
        this.timeInterval.start();
        this.sf.addRepeatWorker(runnable).setBeginAtSameTime(true).start();
        this.timeInterval.stop();
        this.interval = this.timeInterval.getLastTaskTimeMillis();
        return this;
    }

    public ConcurrencyTester reset() {
        this.sf.clearWorker();
        return this;
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public void close() throws IOException {
        this.sf.close();
    }
}

