/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.func.SerBiConsumer;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.func.SerPredicate;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.stream.EasyStream;

public class BeanTree<T, R extends Comparable<R>> {
    private final SerFunction<T, R> idGetter;
    private final SerFunction<T, R> pidGetter;
    private final R pidValue;
    private final SerPredicate<T> parentPredicate;
    private final SerFunction<T, List<T>> childrenGetter;
    private final SerBiConsumer<T, List<T>> childrenSetter;

    private BeanTree(SerFunction<T, R> idGetter, SerFunction<T, R> pidGetter, R pidValue, SerPredicate<T> parentPredicate, SerFunction<T, List<T>> childrenGetter, SerBiConsumer<T, List<T>> childrenSetter) {
        this.idGetter = Objects.requireNonNull(idGetter, "idGetter must not be null");
        this.pidGetter = Objects.requireNonNull(pidGetter, "pidGetter must not be null");
        this.pidValue = pidValue;
        this.parentPredicate = parentPredicate;
        this.childrenGetter = Objects.requireNonNull(childrenGetter, "childrenGetter must not be null");
        this.childrenSetter = Objects.requireNonNull(childrenSetter, "childrenSetter must not be null");
    }

    public static <T, R extends Comparable<R>> BeanTree<T, R> of(SerFunction<T, R> idGetter, SerFunction<T, R> pidGetter, R pidValue, SerFunction<T, List<T>> childrenGetter, SerBiConsumer<T, List<T>> childrenSetter) {
        return new BeanTree<T, R>(idGetter, pidGetter, pidValue, null, childrenGetter, childrenSetter);
    }

    public static <T, R extends Comparable<R>> BeanTree<T, R> ofMatch(SerFunction<T, R> idGetter, SerFunction<T, R> pidGetter, SerPredicate<T> parentPredicate, SerFunction<T, List<T>> childrenGetter, SerBiConsumer<T, List<T>> childrenSetter) {
        return new BeanTree<T, Object>(idGetter, pidGetter, null, Objects.requireNonNull(parentPredicate, "parentPredicate must not be null"), childrenGetter, childrenSetter);
    }

    public List<T> toTree(List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return ListUtil.zero();
        }
        if (Objects.isNull(this.parentPredicate)) {
            Map<R, List<T>> pIdValuesMap = ((EasyStream)EasyStream.of(list).peek(e -> {
                Comparable cfr_ignored_0 = (Comparable)Objects.requireNonNull(this.idGetter.apply(e), () -> "The id of tree node must not be null " + e);
            })).group(this.pidGetter);
            List parents = pIdValuesMap.getOrDefault(this.pidValue, new ArrayList());
            this.findChildren(list, pIdValuesMap);
            return parents;
        }
        ArrayList parents = new ArrayList();
        Map<R, List<T>> pIdValuesMap = ((EasyStream)EasyStream.of(list).peek(e -> {
            if (this.parentPredicate.test(e)) {
                parents.add(e);
            }
            Objects.requireNonNull(this.idGetter.apply(e));
        })).group(this.pidGetter);
        this.findChildren(list, pIdValuesMap);
        return parents;
    }

    public List<T> flat(List<T> tree) {
        AtomicReference<Function<Object, EasyStream>> recursiveRef = new AtomicReference<Function<Object, EasyStream>>();
        Function<Object, EasyStream> recursive = e -> (EasyStream)EasyStream.of((Iterable)this.childrenGetter.apply(e)).flat((Function)recursiveRef.get()).unshift(e);
        recursiveRef.set(recursive);
        return ((EasyStream)EasyStream.of(tree).flat(recursive).peek(e -> this.childrenSetter.accept(e, null))).toList();
    }

    public List<T> filter(List<T> tree, SerPredicate<T> condition) {
        Objects.requireNonNull(condition, "filter condition must be not null");
        AtomicReference recursiveRef = new AtomicReference();
        SerPredicate[] serPredicateArray = new SerPredicate[2];
        serPredicateArray[0] = condition::test;
        serPredicateArray[1] = e -> Opt.ofEmptyAble((Collection)this.childrenGetter.apply(e)).map(children -> ((EasyStream)EasyStream.of(children).filter((Predicate)recursiveRef.get())).toList()).ifPresent(children -> this.childrenSetter.accept(e, (List<Object>)children)).filter(s -> !s.isEmpty()).isPresent();
        SerPredicate recursive = SerPredicate.multiOr(serPredicateArray);
        recursiveRef.set(recursive);
        return ((EasyStream)EasyStream.of(tree).filter((Predicate)recursive)).toList();
    }

    public List<T> forEach(List<T> tree, SerConsumer<T> action) {
        Objects.requireNonNull(action, "action must be not null");
        AtomicReference recursiveRef = new AtomicReference();
        SerConsumer[] serConsumerArray = new SerConsumer[2];
        serConsumerArray[0] = action::accept;
        serConsumerArray[1] = e -> Opt.ofEmptyAble((Collection)this.childrenGetter.apply(e)).ifPresent(children -> EasyStream.of(children).forEach((Consumer)recursiveRef.get()));
        SerConsumer recursive = SerConsumer.multi(serConsumerArray);
        recursiveRef.set(recursive);
        EasyStream.of(tree).forEach(recursive);
        return tree;
    }

    private void findChildren(List<T> list, Map<R, List<T>> pIdValuesMap) {
        for (T node : list) {
            List<T> children = pIdValuesMap.get(this.idGetter.apply(node));
            if (children == null) continue;
            this.childrenSetter.accept(node, children);
        }
    }
}

