/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.util;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.map.MapUtil;

public class JNDIUtil {
    public static InitialDirContext createInitialDirContext(Map<String, String> environment) {
        try {
            if (MapUtil.isEmpty(environment)) {
                return new InitialDirContext();
            }
            return new InitialDirContext(ConvertUtil.convert(Hashtable.class, environment));
        }
        catch (NamingException e) {
            throw new HutoolException(e);
        }
    }

    public static InitialContext createInitialContext(Map<String, String> environment) {
        try {
            if (MapUtil.isEmpty(environment)) {
                return new InitialContext();
            }
            return new InitialContext(ConvertUtil.convert(Hashtable.class, environment));
        }
        catch (NamingException e) {
            throw new HutoolException(e);
        }
    }

    public static Attributes getAttributes(String uri, String ... attrIds) {
        try {
            return JNDIUtil.createInitialDirContext(null).getAttributes(uri, attrIds);
        }
        catch (NamingException e) {
            throw new HutoolException(e);
        }
    }
}

