/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.dromara.hutool.core.comparator.CompareUtil;
import org.dromara.hutool.core.date.CalendarUtil;
import org.dromara.hutool.cron.pattern.PatternUtil;
import org.dromara.hutool.cron.pattern.matcher.PatternMatcher;
import org.dromara.hutool.cron.pattern.parser.PatternParser;

public class CronPattern {
    private final String pattern;
    private final List<PatternMatcher> matchers;

    public static CronPattern of(String pattern) {
        return new CronPattern(pattern);
    }

    public CronPattern(String pattern) {
        this.pattern = pattern;
        this.matchers = PatternParser.parse(pattern);
    }

    public boolean match(long millis, boolean isMatchSecond) {
        return this.match(TimeZone.getDefault(), millis, isMatchSecond);
    }

    public boolean match(TimeZone timezone, long millis, boolean isMatchSecond) {
        GregorianCalendar calendar = new GregorianCalendar(timezone);
        calendar.setTimeInMillis(millis);
        return this.match(calendar, isMatchSecond);
    }

    public boolean match(Calendar calendar, boolean isMatchSecond) {
        return this.match(PatternUtil.getFields(calendar, isMatchSecond));
    }

    public boolean match(LocalDateTime dateTime, boolean isMatchSecond) {
        return this.match(PatternUtil.getFields(dateTime, isMatchSecond));
    }

    public Calendar nextMatchAfter(Calendar calendar) {
        if (this.match(calendar, true)) {
            Calendar newCalendar = Calendar.getInstance(calendar.getTimeZone());
            newCalendar.setTimeInMillis(calendar.getTimeInMillis() + 1000L);
            calendar = newCalendar;
        }
        return this.nextMatch(calendar);
    }

    public Calendar nextMatch(Calendar calendar) {
        Calendar next = this.nextMatchAfter(PatternUtil.getFields(calendar, true), calendar.getTimeZone());
        if (this.match(next, true)) {
            return next;
        }
        next.set(5, next.get(5) + 1);
        next = CalendarUtil.beginOfDay(next);
        return this.nextMatch(next);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronPattern that = (CronPattern)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    public String toString() {
        return this.pattern;
    }

    private boolean match(int[] fields) {
        for (PatternMatcher matcher : this.matchers) {
            if (!matcher.match(fields)) continue;
            return true;
        }
        return false;
    }

    private Calendar nextMatchAfter(int[] values, TimeZone zone) {
        Calendar minMatch = null;
        for (PatternMatcher matcher : this.matchers) {
            if (null == minMatch) {
                minMatch = matcher.nextMatchAfter(values, zone);
                continue;
            }
            minMatch = CompareUtil.min(minMatch, matcher.nextMatchAfter(values, zone));
        }
        return minMatch;
    }
}

