/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern.matcher;

import java.time.Year;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.cron.pattern.Part;
import org.dromara.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import org.dromara.hutool.cron.pattern.matcher.BoolArrayMatcher;
import org.dromara.hutool.cron.pattern.matcher.DayOfMonthMatcher;
import org.dromara.hutool.cron.pattern.matcher.PartMatcher;

public class PatternMatcher {
    private final PartMatcher[] matchers;

    public PatternMatcher(PartMatcher secondMatcher, PartMatcher minuteMatcher, PartMatcher hourMatcher, PartMatcher dayOfMonthMatcher, PartMatcher monthMatcher, PartMatcher dayOfWeekMatcher, PartMatcher yearMatcher) {
        this.matchers = new PartMatcher[]{secondMatcher, minuteMatcher, hourMatcher, dayOfMonthMatcher, monthMatcher, dayOfWeekMatcher, yearMatcher};
    }

    public PartMatcher get(Part part) {
        return this.matchers[part.ordinal()];
    }

    public boolean match(int[] fields) {
        return this.match(fields[0], fields[1], fields[2], fields[3], fields[4], fields[5], fields[6]);
    }

    public boolean matchWeek(int dayOfWeekValue) {
        return this.matchers[5].test(dayOfWeekValue);
    }

    private boolean match(int second, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        return (second < 0 || this.matchers[0].test(second)) && this.matchers[1].test(minute) && this.matchers[2].test(hour) && PatternMatcher.matchDayOfMonth(this.matchers[3], dayOfMonth, month, Year.isLeap(year)) && this.matchers[4].test(month) && this.matchers[5].test(dayOfWeek) && this.matchers[6].test(year);
    }

    private static boolean matchDayOfMonth(PartMatcher matcher, int dayOfMonth, int month, boolean isLeapYear) {
        return matcher instanceof DayOfMonthMatcher ? ((DayOfMonthMatcher)matcher).match(dayOfMonth, month, isLeapYear) : matcher.test(dayOfMonth);
    }

    public Calendar nextMatchAfter(int[] values, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.set(14, 0);
        int[] newValues = this.nextMatchValuesAfter(values);
        for (int i = 0; i < newValues.length; ++i) {
            if (i == Part.DAY_OF_WEEK.ordinal()) continue;
            this.setValue(calendar, Part.of(i), newValues[i]);
        }
        return calendar;
    }

    public String toString() {
        return "PatternMatcher{matchers=" + Arrays.toString(this.matchers) + '}';
    }

    private int[] nextMatchValuesAfter(int[] values) {
        int i = Part.YEAR.ordinal();
        int nextValue = 0;
        while (i >= 0) {
            if (i == Part.DAY_OF_WEEK.ordinal()) {
                --i;
                continue;
            }
            nextValue = this.getNextMatch(values, i, 0);
            if (nextValue > values[i]) {
                values[i] = nextValue;
                --i;
                break;
            }
            if (nextValue < values[i]) {
                ++i;
                nextValue = -1;
                break;
            }
            --i;
        }
        if (-1 == nextValue) {
            while (i <= Part.YEAR.ordinal()) {
                if (i == Part.DAY_OF_WEEK.ordinal()) {
                    ++i;
                    continue;
                }
                nextValue = this.getNextMatch(values, i, 1);
                if (nextValue > values[i]) {
                    values[i] = nextValue;
                    --i;
                    break;
                }
                ++i;
            }
        }
        this.setToMin(values, i);
        return values;
    }

    private int getNextMatch(int[] newValues, int partOrdinal, int plusValue) {
        if (partOrdinal == Part.DAY_OF_MONTH.ordinal() && this.matchers[partOrdinal] instanceof DayOfMonthMatcher) {
            boolean isLeapYear = DateUtil.isLeapYear(newValues[Part.YEAR.ordinal()]);
            int month = newValues[Part.MONTH.ordinal()];
            return ((DayOfMonthMatcher)this.matchers[partOrdinal]).nextAfter(newValues[partOrdinal] + plusValue, month, isLeapYear);
        }
        return this.matchers[partOrdinal].nextAfter(newValues[partOrdinal] + plusValue);
    }

    private void setToMin(int[] values, int toPart) {
        for (int i = toPart; i >= 0; --i) {
            Part part = Part.of(i);
            if (part == Part.DAY_OF_MONTH) {
                boolean isLeapYear = DateUtil.isLeapYear(values[Part.YEAR.ordinal()]);
                int month = values[Part.MONTH.ordinal()];
                PartMatcher partMatcher = this.get(part);
                if (partMatcher instanceof DayOfMonthMatcher) {
                    values[i] = ((DayOfMonthMatcher)partMatcher).getMinValue(month, isLeapYear);
                    continue;
                }
            }
            values[i] = this.getMin(part);
        }
    }

    private int getMin(Part part) {
        int min;
        PartMatcher matcher = this.get(part);
        if (matcher instanceof AlwaysTrueMatcher) {
            min = part.getMin();
        } else if (matcher instanceof BoolArrayMatcher) {
            min = ((BoolArrayMatcher)matcher).getMinValue();
        } else {
            throw new IllegalArgumentException("Invalid matcher: " + matcher.getClass().getName());
        }
        return min;
    }

    private Calendar setValue(Calendar calendar, Part part, int value) {
        switch (part) {
            case MONTH: {
                --value;
                break;
            }
            case DAY_OF_WEEK: {
                ++value;
            }
        }
        calendar.set(part.getCalendarField(), value);
        return calendar;
    }
}

