/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric.paillier;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.crypto.Cipher;
import org.dromara.hutool.crypto.CipherMode;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierCipherSpiImpl;

public class PaillierCipher
implements Cipher {
    private final PaillierCipherSpiImpl impl = new PaillierCipherSpiImpl();

    @Override
    public String getAlgorithmName() {
        return "Paillier";
    }

    @Override
    public int getBlockSize() {
        return this.impl.engineGetBlockSize();
    }

    @Override
    public void init(CipherMode mode, Cipher.Parameters parameters) {
        Assert.isInstanceOf(PaillierParameters.class, parameters, "Only support JceParameters!", new Object[0]);
        PaillierParameters paillierParameters = (PaillierParameters)parameters;
        try {
            this.impl.engineInit(mode.getValue(), paillierParameters.key, paillierParameters.random);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public int getOutputSize(int len) {
        return this.impl.engineGetOutputSize(len);
    }

    @Override
    public int process(byte[] in, int inOff, int len, byte[] out, int outOff) {
        return this.impl.engineUpdate(in, inOff, len, out, outOff);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.impl.engineDoFinal(null, 0, 0, out, outOff);
    }

    @Override
    public byte[] processFinal(byte[] in, int inOffset, int inputLen) {
        return this.impl.engineDoFinal(in, inOffset, inputLen);
    }

    public static class PaillierParameters
    implements Cipher.Parameters {
        private final Key key;
        private final SecureRandom random;

        public PaillierParameters(Key key, SecureRandom random) {
            this.key = key;
            this.random = random;
        }
    }
}

