/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.bc;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.crypto.Mode;
import org.dromara.hutool.crypto.Padding;

public class BCUtil {
    public static ECDomainParameters toDomainParams(ECParameterSpec parameterSpec) {
        return new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
    }

    public static ECDomainParameters toDomainParams(String curveName) {
        return BCUtil.toDomainParams(ECUtil.getNamedCurveByName((String)curveName));
    }

    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    public static byte[] toPkcs1(PrivateKey privateKey) {
        PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        try {
            return pkInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] toPkcs1(PublicKey publicKey) {
        SubjectPublicKeyInfo spkInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        try {
            return spkInfo.parsePublicKey().getEncoded();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedBlockCipher wrap(BlockCipher cipher, Mode mode, Padding padding) {
        switch (mode) {
            case CBC: {
                cipher = CBCBlockCipher.newInstance((BlockCipher)cipher);
                break;
            }
            case CFB: {
                cipher = CFBBlockCipher.newInstance((BlockCipher)cipher, (int)(cipher.getBlockSize() * 8));
                break;
            }
            case CTR: {
                cipher = SICBlockCipher.newInstance((BlockCipher)cipher);
                break;
            }
            case OFB: {
                cipher = new OFBBlockCipher(cipher, cipher.getBlockSize() * 8);
            }
            case CTS: {
                return new CTSBlockCipher(cipher);
            }
        }
        switch (padding) {
            case NoPadding: {
                return new DefaultBufferedBlockCipher(cipher);
            }
            case PKCS5Padding: {
                return new PaddedBufferedBlockCipher(cipher);
            }
            case ZeroPadding: {
                return new PaddedBufferedBlockCipher(cipher, (BlockCipherPadding)new ZeroBytePadding());
            }
            case ISO10126Padding: {
                return new PaddedBufferedBlockCipher(cipher, (BlockCipherPadding)new ISO10126d2Padding());
            }
        }
        return null;
    }
}

