/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.bc;

import java.math.BigInteger;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class ECKeySpecUtil {
    public static ECPrivateKeySpec getPrivateKeySpec(byte[] d, ECParameterSpec parameterSpec) {
        return ECKeySpecUtil.getPrivateKeySpec(BigIntegers.fromUnsignedByteArray((byte[])d), parameterSpec);
    }

    public static ECPrivateKeySpec getPrivateKeySpec(BigInteger d, ECParameterSpec parameterSpec) {
        return new ECPrivateKeySpec(d, parameterSpec);
    }

    public static ECPublicKeySpec getPublicKeySpec(byte[] q, ECParameterSpec parameterSpec) {
        return ECKeySpecUtil.getPublicKeySpec(parameterSpec.getCurve().decodePoint(q), parameterSpec);
    }

    public static ECPublicKeySpec getPublicKeySpec(byte[] x, byte[] y, ECParameterSpec parameterSpec) {
        return ECKeySpecUtil.getPublicKeySpec(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y), parameterSpec);
    }

    public static ECPublicKeySpec getPublicKeySpec(BigInteger x, BigInteger y, ECParameterSpec parameterSpec) {
        return ECKeySpecUtil.getPublicKeySpec(parameterSpec.getCurve().createPoint(x, y), parameterSpec);
    }

    public static ECPublicKeySpec getPublicKeySpec(ECPoint ecPoint, ECParameterSpec parameterSpec) {
        return new ECPublicKeySpec(ecPoint, parameterSpec);
    }

    public static OpenSSHPrivateKeySpec getOpenSSHPrivateKeySpec(byte[] key) {
        return new OpenSSHPrivateKeySpec(key);
    }

    public static OpenSSHPublicKeySpec getOpenSSHPublicKeySpec(byte[] key) {
        return new OpenSSHPublicKeySpec(key);
    }
}

