/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.digest;

import java.security.MessageDigest;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.digest.Digester;

public class DigesterFactory {
    private final MessageDigest prototype;
    private final boolean cloneSupport;

    public static DigesterFactory ofJdk(String algorithm) {
        return DigesterFactory.of(SecureUtil.createJdkMessageDigest(algorithm));
    }

    public static DigesterFactory of(String algorithm) {
        return DigesterFactory.of(SecureUtil.createMessageDigest(algorithm, null));
    }

    public static DigesterFactory of(MessageDigest messageDigest) {
        return new DigesterFactory(messageDigest);
    }

    private DigesterFactory(MessageDigest messageDigest) {
        this.prototype = messageDigest;
        this.cloneSupport = DigesterFactory.checkCloneSupport(messageDigest);
    }

    public Digester createDigester() {
        return new Digester(this.createMessageDigester());
    }

    public MessageDigest createMessageDigester() {
        if (this.cloneSupport) {
            try {
                return (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return SecureUtil.createJdkMessageDigest(this.prototype.getAlgorithm());
    }

    private static boolean checkCloneSupport(MessageDigest messageDigest) {
        try {
            messageDigest.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }
}

