/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.dromara.hutool.core.exception.CloneException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.db.config.DbConfig;

public class DSWrapper
extends SimpleWrapper<DataSource>
implements DataSource,
Closeable,
Cloneable {
    private final DbConfig dbConfig;

    public static DSWrapper wrap(DataSource ds, DbConfig dbConfig) {
        return new DSWrapper(ds, dbConfig);
    }

    public DSWrapper(DataSource ds, DbConfig dbConfig) {
        super(ds);
        this.dbConfig = dbConfig;
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public String getDriver() {
        return this.dbConfig.getDriver();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return ((DataSource)this.raw).getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        ((DataSource)this.raw).setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        ((DataSource)this.raw).setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return ((DataSource)this.raw).getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return ((DataSource)this.raw).getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return ((DataSource)this.raw).unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return ((DataSource)this.raw).isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ((DataSource)this.raw).getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return ((DataSource)this.raw).getConnection(username, password);
    }

    @Override
    public void close() {
        DataSource ds = (DataSource)this.raw;
        if (ds instanceof AutoCloseable) {
            IoUtil.closeQuietly((AutoCloseable)((Object)ds));
        }
    }

    public DSWrapper clone() {
        try {
            return (DSWrapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

