/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.handler.RsHandler;
import org.dromara.hutool.db.sql.NamedSql;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.StatementUtil;

public class SqlExecutor {
    private final DbConfig config;
    private final Connection conn;

    public static SqlExecutor of(DbConfig config, Connection conn) {
        return new SqlExecutor(config, conn);
    }

    public SqlExecutor(DbConfig config, Connection conn) {
        this.config = config;
        this.conn = conn;
    }

    public int execute(String sql, Map<String, Object> paramMap) throws DbException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return this.execute(namedSql.getSql(), namedSql.getParamArray());
    }

    public int execute(String sql, Object ... params) throws DbException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(false, this.config, this.conn, sql, params);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(ps);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(ps);
        return n;
    }

    public boolean call(String sql, Object ... params) throws DbException {
        boolean bl;
        CallableStatement call = null;
        try {
            call = StatementUtil.prepareCall(this.config, this.conn, sql, params);
            bl = call.execute();
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(call);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(call);
        return bl;
    }

    public ResultSet callQuery(String sql, Object ... params) throws DbException {
        try {
            return StatementUtil.prepareCall(this.config, this.conn, sql, params).executeQuery();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public Long executeForGeneratedKey(String sql, Map<String, Object> paramMap) throws DbException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return this.executeForGeneratedKey(namedSql.getSql(), namedSql.getParamArray());
    }

    public Long executeForGeneratedKey(String sql, Object ... params) throws DbException {
        Long l;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(true, this.config, this.conn, sql, params);
            ps.executeUpdate();
            l = StatementUtil.getGeneratedKeyOfLong(ps);
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(ps);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(ps);
        return l;
    }

    public int[] executeBatch(String sql, Iterable<Object[]> paramsBatch) throws DbException {
        int[] nArray;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatementForBatch(this.config, this.conn, sql, paramsBatch);
            nArray = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(ps);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(ps);
        return nArray;
    }

    public int[] executeBatch(String ... sqls) throws DbException {
        return this.executeBatch(new ArrayIter<String>((E[])sqls));
    }

    public int[] executeBatch(Iterable<String> sqls) throws DbException {
        Object object;
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            object = statement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(statement);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(statement);
        return object;
    }

    public <T> T query(String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws DbException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return this.query(namedSql.getSql(), rsh, namedSql.getParamArray());
    }

    public <T> T query(SqlBuilder sqlBuilder, RsHandler<T> rsh) throws DbException {
        return this.query(sqlBuilder.build(), rsh, sqlBuilder.getParamValueArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws DbException {
        T t;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(false, this.config, this.conn, sql, params);
            t = StatementUtil.executeQuery(ps, rsh);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(ps);
            throw throwable;
        }
        IoUtil.closeQuietly(ps);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(SerFunction<Connection, PreparedStatement> statementFunc, RsHandler<T> rsh) throws DbException {
        T t;
        PreparedStatement ps = null;
        try {
            ps = statementFunc.apply(this.conn);
            t = StatementUtil.executeQuery(ps, rsh);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(ps);
            throw throwable;
        }
        IoUtil.closeQuietly(ps);
        return t;
    }
}

