/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mq.engine.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DeliverCallback;
import java.io.IOException;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.extra.mq.Consumer;
import org.dromara.hutool.extra.mq.MQException;
import org.dromara.hutool.extra.mq.Message;
import org.dromara.hutool.extra.mq.MessageHandler;

public class RabbitMQConsumer
implements Consumer {
    private final Channel channel;
    private String topic;

    public RabbitMQConsumer(Channel channel) {
        this.channel = channel;
    }

    public RabbitMQConsumer setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    @Override
    public void subscribe(MessageHandler messageHandler) {
        this.queueDeclare(false, false, false, null);
        DeliverCallback deliverCallback = (consumerTag, delivery) -> messageHandler.handle(new Message(){

            @Override
            public String topic() {
                return consumerTag;
            }

            @Override
            public byte[] content() {
                return delivery.getBody();
            }
        });
        try {
            this.channel.basicConsume(this.topic, true, deliverCallback, consumerTag -> {});
        }
        catch (IOException e) {
            throw new MQException(e);
        }
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(new AutoCloseable[]{this.channel});
    }

    private void queueDeclare(boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        try {
            this.channel.queueDeclare(this.topic, durable, exclusive, autoDelete, arguments);
        }
        catch (IOException e) {
            throw new MQException(e);
        }
    }
}

