/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.okhttp;

import java.util.ArrayList;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.http.client.cookie.CookieSpi;
import org.dromara.hutool.http.client.cookie.CookieStoreSpi;
import org.dromara.hutool.http.client.engine.okhttp.OkCookie;

public class CookieJarImpl
implements CookieJar {
    private final CookieStoreSpi cookieStore;

    public CookieJarImpl(CookieStoreSpi cookieStore) {
        this.cookieStore = cookieStore;
    }

    public CookieStoreSpi getCookieStore() {
        return this.cookieStore;
    }

    public List<Cookie> loadForRequest(HttpUrl httpUrl) {
        List<CookieSpi> cookieSpis = this.cookieStore.get(httpUrl.uri());
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieSpis.size());
        for (CookieSpi cookieSpi : cookieSpis) {
            cookies.add((Cookie)((OkCookie)cookieSpi).getRaw());
        }
        return cookies;
    }

    public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        for (Cookie cookie : list) {
            this.cookieStore.add(httpUrl.uri(), new OkCookie(cookie));
        }
    }
}

