/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.handler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.net.url.UrlEncoder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.meta.ContentType;
import org.dromara.hutool.http.meta.HeaderName;

public interface ServerResponse {
    public static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;

    public ServerResponse setStatus(int var1);

    public ServerResponse setCharset(Charset var1);

    public Charset getCharset();

    public ServerResponse addHeader(String var1, String var2);

    public ServerResponse setHeader(String var1, String var2);

    default public ServerResponse setHeader(HeaderName headerName, String value) {
        return this.setHeader(headerName.getValue(), value);
    }

    default public ServerResponse setHeader(String header, List<String> value) {
        this.setHeader(header, (String)null);
        if (null == value) {
            return this;
        }
        for (String valueItem : value) {
            this.addHeader(header, valueItem);
        }
        return this;
    }

    default public ServerResponse setContentType(String contentType) {
        Charset charset;
        if (null != contentType && null != (charset = this.getCharset()) && !contentType.contains(";charset=")) {
            contentType = ContentType.build(contentType, charset);
        }
        return this.setHeader(HeaderName.CONTENT_TYPE, contentType);
    }

    default public ServerResponse setContentLength(long contentLength) {
        return this.setHeader(HeaderName.CONTENT_LENGTH, contentLength < 0L ? null : String.valueOf(contentLength));
    }

    public OutputStream getOutputStream();

    default public PrintWriter getWriter() {
        Charset charset = ObjUtil.defaultIfNull(this.getCharset(), DEFAULT_CHARSET);
        return new PrintWriter(new OutputStreamWriter(this.getOutputStream(), charset));
    }

    default public ServerResponse write(String data, String contentType) {
        this.setContentType(contentType);
        return this.write(data);
    }

    default public ServerResponse write(String data) {
        Charset charset = ObjUtil.defaultIfNull(this.getCharset(), DEFAULT_CHARSET);
        return this.write(ByteUtil.toBytes(data, charset));
    }

    default public ServerResponse write(byte[] data, String contentType) {
        this.setContentType(contentType);
        return this.write(data);
    }

    default public ServerResponse write(byte[] data) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        return this.write((InputStream)in, in.available());
    }

    default public ServerResponse write(InputStream in, String contentType) {
        return this.write(in, 0, contentType);
    }

    default public ServerResponse write(InputStream in, int length, String contentType) {
        this.setContentType(contentType);
        return this.write(in, length);
    }

    default public ServerResponse write(InputStream in) {
        return this.write(in, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ServerResponse write(InputStream in, int length) {
        this.setContentLength(length);
        OutputStream out = null;
        try {
            out = this.getOutputStream();
            IoUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(out);
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(out);
        IoUtil.closeQuietly(in);
        return this;
    }

    default public ServerResponse write(File file) {
        return this.write(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ServerResponse write(File file, String fileName) {
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File size is too bigger than 2147483647");
        }
        if (StrUtil.isBlank(fileName)) {
            fileName = file.getName();
        }
        String contentType = FileUtil.getMimeType(fileName, ContentType.OCTET_STREAM.getValue());
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            this.write(in, (int)fileSize, contentType, fileName);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        return this;
    }

    default public ServerResponse write(InputStream in, String contentType, String fileName) {
        return this.write(in, 0, contentType, fileName);
    }

    default public ServerResponse write(InputStream in, int length, String contentType, String fileName) {
        Charset charset = ObjUtil.defaultIfNull(this.getCharset(), DEFAULT_CHARSET);
        if (!contentType.startsWith("text/")) {
            this.setHeader(HeaderName.CONTENT_DISPOSITION, StrUtil.format("attachment;filename={}", UrlEncoder.encodeAll(fileName, charset)));
        }
        return this.write(in, length, contentType);
    }
}

