/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.Date;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class DateMoshiAdapter
extends JsonAdapter<Date> {
    private final String dateFormat;

    public static JsonAdapter.Factory createFactory(String dateFormat) {
        return (type, set, moshi) -> {
            if (Date.class.isAssignableFrom(TypeUtil.getClass(type))) {
                return new DateMoshiAdapter(dateFormat);
            }
            return null;
        };
    }

    public DateMoshiAdapter(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void toJson(JsonWriter jsonWriter, Date date) throws IOException {
        if (null == date) {
            jsonWriter.nullValue();
            return;
        }
        if (StrUtil.isEmpty(this.dateFormat)) {
            jsonWriter.value(date.getTime());
        } else {
            jsonWriter.value(DateUtil.format(date, this.dateFormat));
        }
    }

    public Date fromJson(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonReader.Token.NULL) {
            return (Date)jsonReader.nextNull();
        }
        return StrUtil.isEmpty(this.dateFormat) ? DateUtil.date(jsonReader.nextLong()) : DateUtil.parse((CharSequence)jsonReader.nextString(), this.dateFormat);
    }
}

