/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class EntryTypeAdapter
implements MatcherJSONSerializer<Map.Entry<?, ?>>,
MatcherJSONDeserializer<Map.Entry<?, ?>> {
    public static final EntryTypeAdapter INSTANCE = new EntryTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof Map.Entry;
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        if (json instanceof JSONObject) {
            Class<?> rawType = TypeUtil.getClass(deserializeType);
            return Map.Entry.class.isAssignableFrom(rawType);
        }
        return false;
    }

    @Override
    public JSON serialize(Map.Entry<?, ?> bean, JSONContext context) {
        return context.getOrCreateObj().putValue(ConvertUtil.toStr(bean.getKey()), bean.getValue());
    }

    @Override
    public Map.Entry<?, ?> deserialize(JSON json, Type deserializeType) {
        Type keyType = TypeUtil.getTypeArgument(deserializeType, 0);
        Type valueType = TypeUtil.getTypeArgument(deserializeType, 1);
        return this.toEntry(deserializeType, keyType, valueType, (JSONObject)json);
    }

    private Map.Entry<?, ?> toEntry(Type targetType, Type keyType, Type valueType, JSONObject json) {
        JSON value;
        String key;
        if (1 == json.size()) {
            Map.Entry entry = json.iterator().next();
            key = (String)entry.getKey();
            value = (JSON)entry.getValue();
        } else {
            key = json.getStr("key");
            value = (JSON)json.get("value");
        }
        return (Map.Entry)ConstructorUtil.newInstance(TypeUtil.getClass(targetType), TypeUtil.isUnknown(keyType) ? key : CompositeConverter.getInstance().convert(keyType, (Object)key), TypeUtil.isUnknown(valueType) ? value : value.toBean(valueType));
    }
}

