/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.log.engine;

import java.net.URL;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.log.LogFactory;
import org.dromara.hutool.log.engine.LogEngine;
import org.dromara.hutool.log.engine.console.ConsoleLogEngine;
import org.dromara.hutool.log.engine.jdk.JdkLogEngine;

public class LogEngineFactory {
    public static LogEngine getEngine() {
        return InstanceHolder.INSTANCE;
    }

    public static void setDefaultEngine(Class<? extends LogEngine> logEngineClass) {
        try {
            LogEngineFactory.setDefaultEngine(ConstructorUtil.newInstance(logEngineClass, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not instance LogFactory class!", e);
        }
    }

    public static void setDefaultEngine(LogEngine logEngine) {
        Singleton.put(LogEngineFactory.class.getName(), logEngine);
        logEngine.createLog(LogEngineFactory.class).debug("Custom Use [{}] Logger.", logEngine.getName());
    }

    public static LogEngine createEngine(Class<? extends LogEngine> logEngineClass) {
        return ConstructorUtil.newInstance(logEngineClass, new Object[0]);
    }

    public static LogEngine createEngine() {
        LogEngine engine = LogEngineFactory.doCreateEngine();
        engine.createLog(LogFactory.class).debug("Use [{}] Logger As Default.", engine.getName());
        return engine;
    }

    private static LogEngine doCreateEngine() {
        LogEngine engine = SpiUtil.loadFirstAvailable(LogEngine.class);
        if (null != engine) {
            return engine;
        }
        URL url = ResourceUtil.getResourceUrl("logging.properties");
        return null != url ? new JdkLogEngine() : new ConsoleLogEngine();
    }

    private static class InstanceHolder {
        public static final LogEngine INSTANCE = LogEngineFactory.createEngine();

        private InstanceHolder() {
        }
    }
}

