/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;

public class CsvTokener
extends SimpleWrapper<Reader>
implements Closeable {
    private long index;
    private int prev;
    private boolean usePrev;

    public CsvTokener(Reader reader) {
        super(IoUtil.toBuffered(reader));
    }

    public int next() {
        if (this.usePrev) {
            this.usePrev = false;
        } else {
            try {
                this.prev = ((Reader)this.raw).read();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        ++this.index;
        return this.prev;
    }

    public void back() throws IllegalStateException {
        if (this.usePrev || this.index <= 0L) {
            throw new IllegalStateException("Stepping back two steps is not supported");
        }
        --this.index;
        this.usePrev = true;
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public void close() throws IOException {
        IoUtil.nullSafeClose((Closeable)this.raw);
    }
}

