/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.POIException;
import org.dromara.hutool.poi.excel.sax.ExcelSaxReader;
import org.dromara.hutool.poi.excel.sax.ExcelSaxUtil;
import org.dromara.hutool.poi.excel.sax.SheetDataSaxHandler;
import org.dromara.hutool.poi.excel.sax.SheetRidReader;
import org.dromara.hutool.poi.excel.sax.handler.RowHandler;

public class Excel07SaxReader
implements ExcelSaxReader<Excel07SaxReader> {
    private final SheetDataSaxHandler handler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this(rowHandler, false);
    }

    public Excel07SaxReader(RowHandler rowHandler, boolean padCellAtEndOfRow) {
        this.handler = new SheetDataSaxHandler(rowHandler, padCellAtEndOfRow);
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.handler.setRowHandler(rowHandler);
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws POIException {
        return this.read(file, "rId" + rid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel07SaxReader read(File file, String idOrRidOrSheetName) throws POIException {
        try (OPCPackage open = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            Excel07SaxReader excel07SaxReader = this.read(open, idOrRidOrSheetName);
            return excel07SaxReader;
        }
        catch (IOException | InvalidFormatException e) {
            throw new POIException(e);
        }
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws POIException {
        return this.read(in, "rId" + rid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel07SaxReader read(InputStream in, String idOrRidOrSheetName) throws POIException {
        try (OPCPackage opcPackage = OPCPackage.open((InputStream)in);){
            Excel07SaxReader excel07SaxReader = this.read(opcPackage, idOrRidOrSheetName);
            return excel07SaxReader;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws POIException {
        return this.read(opcPackage, "rId" + rid);
    }

    public Excel07SaxReader read(OPCPackage opcPackage, String idOrRidOrSheetName) throws POIException {
        try {
            return this.read(new XSSFReader(opcPackage), idOrRidOrSheetName);
        }
        catch (OpenXML4JException e) {
            throw new POIException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public Excel07SaxReader read(XSSFReader xssfReader, String idOrRidOrSheetName) throws POIException {
        try {
            this.handler.stylesTable = xssfReader.getStylesTable();
        }
        catch (IOException | InvalidFormatException throwable) {
            // empty catch block
        }
        this.handler.sharedStrings = (SharedStrings)MethodUtil.invoke((Object)xssfReader, "getSharedStringsTable", new Object[0]);
        return this.readSheets(xssfReader, idOrRidOrSheetName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Excel07SaxReader readSheets(XSSFReader xssfReader, String idOrRidOrSheetName) throws POIException {
        this.handler.sheetIndex = this.getSheetIndex(xssfReader, idOrRidOrSheetName);
        InputStream sheetInputStream = null;
        try {
            if (this.handler.sheetIndex > -1) {
                sheetInputStream = xssfReader.getSheet("rId" + (this.handler.sheetIndex + 1));
                ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                this.handler.rowHandler.doAfterAllAnalysed();
            } else {
                this.handler.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.handler.index = 0;
                    ++this.handler.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                    this.handler.rowHandler.doAfterAllAnalysed();
                }
            }
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new POIException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(sheetInputStream);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(sheetInputStream);
        return this;
    }

    private int getSheetIndex(XSSFReader xssfReader, String idOrRidOrSheetName) {
        if (StrUtil.startWithIgnoreCase(idOrRidOrSheetName, "rId")) {
            return Integer.parseInt(StrUtil.removePrefixIgnoreCase(idOrRidOrSheetName, "rId"));
        }
        SheetRidReader ridReader = SheetRidReader.parse(xssfReader);
        if (StrUtil.startWithIgnoreCase(idOrRidOrSheetName, "sheetName:")) {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName = StrUtil.removePrefixIgnoreCase(idOrRidOrSheetName, "sheetName:"));
            if (null != rid) {
                return rid;
            }
        } else {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName);
            if (null != rid) {
                return rid;
            }
            try {
                int sheetIndex = Integer.parseInt(idOrRidOrSheetName);
                rid = ridReader.getRidBySheetIdBase0(sheetIndex);
                return ObjUtil.defaultIfNull(rid, sheetIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid rId or id or sheetName: " + idOrRidOrSheetName);
    }
}

