/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.sax.handler;

import java.util.List;
import java.util.function.Function;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.poi.excel.sax.handler.RowHandler;

public abstract class AbstractRowHandler<T>
implements RowHandler {
    protected final int startRowIndex;
    protected final int endRowIndex;
    protected Function<List<Object>, T> convertFunc;

    public AbstractRowHandler(int startRowIndex, int endRowIndex) {
        this.startRowIndex = startRowIndex;
        this.endRowIndex = endRowIndex;
    }

    @Override
    public void handle(int sheetIndex, long rowIndex, List<Object> rowCells) {
        Assert.notNull(this.convertFunc);
        if (rowIndex < (long)this.startRowIndex || rowIndex > (long)this.endRowIndex) {
            return;
        }
        this.handleData(sheetIndex, rowIndex, this.convertFunc.apply(rowCells));
    }

    public abstract void handleData(int var1, long var2, T var4);
}

