/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.writer;

import java.awt.Color;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.dromara.hutool.poi.excel.SimpleClientAnchor;
import org.dromara.hutool.poi.excel.shape.ExcelPicType;
import org.dromara.hutool.poi.excel.style.ShapeConfig;

public class ExcelDrawingUtil {
    public static void drawingPic(Sheet sheet, byte[] pictureData, ExcelPicType imgType, SimpleClientAnchor clientAnchor) {
        Drawing patriarch = sheet.createDrawingPatriarch();
        Workbook workbook = sheet.getWorkbook();
        ClientAnchor anchor = workbook.getCreationHelper().createClientAnchor();
        clientAnchor.copyTo(anchor);
        patriarch.createPicture(anchor, workbook.addPicture(pictureData, imgType.getValue()));
    }

    public static void drawingSimpleShape(Sheet sheet, SimpleClientAnchor clientAnchor, ShapeConfig shapeConfig) {
        Drawing patriarch = sheet.createDrawingPatriarch();
        ClientAnchor anchor = sheet.getWorkbook().getCreationHelper().createClientAnchor();
        clientAnchor.copyTo(anchor);
        if (null == shapeConfig) {
            shapeConfig = ShapeConfig.of();
        }
        Color lineColor = shapeConfig.getLineColor();
        if (patriarch instanceof HSSFPatriarch) {
            HSSFSimpleShape simpleShape = ((HSSFPatriarch)patriarch).createSimpleShape((HSSFClientAnchor)anchor);
            simpleShape.setShapeType(shapeConfig.getShapeType().ooxmlId);
            simpleShape.setLineStyle(shapeConfig.getLineStyle().getValue());
            simpleShape.setLineWidth(shapeConfig.getLineWidth());
            if (null != lineColor) {
                simpleShape.setLineStyleColor(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue());
            }
        } else if (patriarch instanceof XSSFDrawing) {
            XSSFSimpleShape simpleShape = ((XSSFDrawing)patriarch).createSimpleShape((XSSFClientAnchor)anchor);
            simpleShape.setShapeType(shapeConfig.getShapeType().ooxmlId);
            simpleShape.setLineStyle(shapeConfig.getLineStyle().getValue());
            simpleShape.setLineWidth((double)shapeConfig.getLineWidth());
            if (null != lineColor) {
                simpleShape.setLineStyleColor(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue());
            }
        } else {
            throw new UnsupportedOperationException("Unsupported patriarch type: " + patriarch.getClass().getName());
        }
    }

    public static void drawingCellComment(Cell cell, SimpleClientAnchor clientAnchor, String content) {
        Sheet sheet = cell.getSheet();
        Drawing patriarch = sheet.createDrawingPatriarch();
        Workbook workbook = sheet.getWorkbook();
        ClientAnchor anchor = workbook.getCreationHelper().createClientAnchor();
        clientAnchor.copyTo(anchor);
        RichTextString richTextString = workbook.getCreationHelper().createRichTextString(content);
        Comment cellComment = patriarch.createCellComment(anchor);
        cellComment.setString(richTextString);
        cell.setCellComment(cellComment);
    }
}

