/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.img;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.swing.img.ImgUtil;

public class ImgWriter
implements Flushable {
    private final RenderedImage image;
    private final ImageWriter writer;
    private ImageWriteParam writeParam;

    public static ImgWriter of(Image image, String imageType, Color backgroundColor) {
        return ImgWriter.of(ImgUtil.toBufferedImage(image, imageType, backgroundColor), imageType);
    }

    public static ImgWriter of(Image image, String imageType) {
        return new ImgWriter(image, imageType);
    }

    public ImgWriter(Image image, String imageType) {
        this.image = ImgUtil.castToRenderedImage(image, imageType);
        this.writer = ImgUtil.getWriter(image, imageType);
    }

    public ImgWriter setQuality(float quality) {
        this.writeParam = ImgWriter.buildParam(this.image, this.writer, quality);
        return this;
    }

    public void write(OutputStream out) throws IORuntimeException {
        this.write(ImgUtil.getImageOutputStream(out));
    }

    public void write(File targetFile) throws IORuntimeException {
        FileUtil.touch(targetFile);
        ImageOutputStream out = null;
        try {
            out = ImgUtil.getImageOutputStream(targetFile);
            this.write(out);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(out);
            throw throwable;
        }
        IoUtil.closeQuietly(out);
    }

    public void write(ImageOutputStream output) {
        Assert.notNull(output);
        ImageWriter writer = this.writer;
        RenderedImage image = this.image;
        writer.setOutput(output);
        try {
            if (null != this.writeParam) {
                writer.write(null, new IIOImage(image, null, null), this.writeParam);
            } else {
                writer.write(image);
            }
            output.flush();
            writer.dispose();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                writer.dispose();
                IoUtil.closeQuietly(output);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(output);
    }

    @Override
    public void flush() {
        RenderedImage renderedImage = this.image;
        if (renderedImage instanceof BufferedImage) {
            ImgUtil.flush((BufferedImage)renderedImage);
        } else if (renderedImage instanceof Image) {
            ImgUtil.flush((Image)((Object)renderedImage));
        }
    }

    private static ImageWriteParam buildParam(RenderedImage renderedImage, ImageWriter writer, float quality) {
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        return imgWriteParams;
    }
}

