/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.core;

import java.lang.reflect.Constructor;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.AIConfigRegistry;

public class AIConfigBuilder {
    private final AIConfig config;

    public AIConfigBuilder(String modelName) {
        try {
            Class<? extends AIConfig> configClass = AIConfigRegistry.getConfigClass(modelName);
            if (configClass == null) {
                throw new IllegalArgumentException("Unsupported model: " + modelName);
            }
            Constructor<? extends AIConfig> constructor = configClass.getDeclaredConstructor(new Class[0]);
            this.config = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create AIConfig instance", e);
        }
    }

    public synchronized AIConfigBuilder setApiKey(String apiKey) {
        if (apiKey != null) {
            this.config.setApiKey(apiKey);
        }
        return this;
    }

    public synchronized AIConfigBuilder setApiUrl(String apiUrl) {
        if (apiUrl != null) {
            this.config.setApiUrl(apiUrl);
        }
        return this;
    }

    public synchronized AIConfigBuilder setModel(String model) {
        if (model != null) {
            this.config.setModel(model);
        }
        return this;
    }

    public AIConfigBuilder putAdditionalConfig(String key, Object value) {
        if (value != null) {
            this.config.putAdditionalConfigByKey(key, value);
        }
        return this;
    }

    public synchronized AIConfigBuilder setTimout(int timeout) {
        if (timeout > 0) {
            this.config.setTimeout(timeout);
        }
        return this;
    }

    public synchronized AIConfigBuilder setReadTimout(int readTimout) {
        if (readTimout > 0) {
            this.config.setReadTimeout(readTimout);
        }
        return this;
    }

    public AIConfig build() {
        return this.config;
    }
}

