/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.model.deepseek;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.BaseAIService;
import org.dromara.hutool.ai.core.Message;
import org.dromara.hutool.ai.model.deepseek.DeepSeekService;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.json.JSONUtil;

public class DeepSeekServiceImpl
extends BaseAIService
implements DeepSeekService {
    private final String CHAT_ENDPOINT = "/chat/completions";
    private final String BETA_ENDPOINT = "/beta/completions";
    private final String MODELS_ENDPOINT = "/models";
    private final String BALANCE_ENDPOINT = "/user/balance";

    public DeepSeekServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chat(List<Message> messages, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatStreamRequestBody(messages);
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), "deepseek-chat-sse").start();
    }

    @Override
    public String beta(String prompt) {
        String paramJson = this.buildBetaRequestBody(prompt);
        Response response = this.sendPost("/beta/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void beta(String prompt, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildBetaStreamRequestBody(prompt);
        ThreadUtil.newThread(() -> this.sendPostStream("/beta/completions", paramMap, callback::accept), "deepseek-beta-sse").start();
    }

    @Override
    public String models() {
        Response response = this.sendGet("/models");
        return response.bodyStr();
    }

    @Override
    public String balance() {
        Response response = this.sendGet("/user/balance");
        return response.bodyStr();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatStreamRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildBetaRequestBody(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildBetaStreamRequestBody(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }
}

