/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.model.grok;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.BaseAIService;
import org.dromara.hutool.ai.core.Message;
import org.dromara.hutool.ai.model.grok.GrokService;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.json.JSONUtil;

public class GrokServiceImpl
extends BaseAIService
implements GrokService {
    private final String CHAT_ENDPOINT = "/chat/completions";
    private final String MESSAGES = "/messages";
    private final String MODELS_ENDPOINT = "/models";
    private final String LANGUAGE_MODELS = "/language-models";
    private final String TOKENIZE_TEXT = "/tokenize-text";
    private final String DEFERRED_COMPLETION = "/chat/deferred-completion";
    private final String IMAGES_GENERATIONS = "/images/generations";

    public GrokServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chat(List<Message> messages, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatStreamRequestBody(messages);
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), "grok-chat-sse").start();
    }

    @Override
    public String message(List<Message> messages, int maxToken) {
        String paramJson = this.buildMessageRequestBody(messages, maxToken);
        Response response = this.sendPost("/messages", paramJson);
        return response.bodyStr();
    }

    @Override
    public void message(List<Message> messages, int maxToken, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildMessageStreamRequestBody(messages, maxToken);
        ThreadUtil.newThread(() -> this.sendPostStream("/messages", paramMap, callback::accept), "grok-message-sse").start();
    }

    @Override
    public String chatVision(String prompt, List<String> images, String detail) {
        String paramJson = this.buildChatVisionRequestBody(prompt, images, detail);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chatVision(String prompt, List<String> images, String detail, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatVisionStreamRequestBody(prompt, images, detail);
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), "grok-chatVision-sse").start();
    }

    @Override
    public String models() {
        Response response = this.sendGet("/models");
        return response.bodyStr();
    }

    @Override
    public String getModel(String modelId) {
        Response response = this.sendGet("/models/" + modelId);
        return response.bodyStr();
    }

    @Override
    public String languageModels() {
        Response response = this.sendGet("/language-models");
        return response.bodyStr();
    }

    @Override
    public String getLanguageModel(String modelId) {
        Response response = this.sendGet("/language-models/" + modelId);
        return response.bodyStr();
    }

    @Override
    public String tokenizeText(String text) {
        String paramJson = this.buildTokenizeRequestBody(text);
        Response response = this.sendPost("/tokenize-text", paramJson);
        return response.bodyStr();
    }

    @Override
    public String deferredCompletion(String requestId) {
        Response response = this.sendGet("/chat/deferred-completion/" + requestId);
        return response.bodyStr();
    }

    @Override
    public String imagesGenerations(String prompt) {
        String paramJson = this.buildImagesGenerationsRequestBody(prompt);
        Response response = this.sendPost("/images/generations", paramJson);
        return response.bodyStr();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatStreamRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildChatVisionRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatVisionStreamRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildMessageRequestBody(List<Message> messages, int maxToken) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.put("max_tokens", maxToken);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildMessageStreamRequestBody(List<Message> messages, int maxToken) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.put("max_tokens", maxToken);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildTokenizeRequestBody(String text) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("text", text);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildImagesGenerationsRequestBody(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }
}

