/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data;

import org.dromara.hutool.core.data.masking.RichTextMaskingProcessor;
import org.dromara.hutool.core.data.masking.RichTextMaskingRule;

public class RichTextMaskingUtil {
    private static final RichTextMaskingProcessor DEFAULT_PROCESSOR = RichTextMaskingUtil.createDefaultProcessor();

    private static RichTextMaskingProcessor createDefaultProcessor() {
        RichTextMaskingProcessor processor = new RichTextMaskingProcessor(true);
        processor.addRule(new RichTextMaskingRule("\u90ae\u7bb1", "[\\w.-]+@[\\w.-]+\\.\\w+", RichTextMaskingRule.MaskType.PARTIAL, "[\u90ae\u7bb1\u5df2\u9690\u85cf]").setPreserveLeft(1).setPreserveRight(0).setMaskChar('*'));
        processor.addRule(new RichTextMaskingRule("\u7f51\u5740", "https?://[\\w.-]+(?:/[\\w.-]*)*", RichTextMaskingRule.MaskType.REPLACE, "[\u7f51\u5740\u5df2\u9690\u85cf]"));
        processor.addRule(new RichTextMaskingRule("\u654f\u611f\u8bcd", "(\u673a\u5bc6|\u7edd\u5bc6|\u5185\u90e8\u8d44\u6599|\u79d8\u5bc6|\u4fdd\u5bc6)", RichTextMaskingRule.MaskType.FULL, "***").setMaskChar('*'));
        return processor;
    }

    public static String mask(String text) {
        return DEFAULT_PROCESSOR.mask(text);
    }

    public static String mask(String text, RichTextMaskingProcessor processor) {
        return processor.mask(text);
    }

    public static RichTextMaskingProcessor createProcessor(boolean preserveHtmlTags) {
        return new RichTextMaskingProcessor(preserveHtmlTags);
    }

    public static RichTextMaskingRule createEmailRule() {
        return new RichTextMaskingRule("\u90ae\u7bb1", "[\\w.-]+@[\\w.-]+\\.\\w+", RichTextMaskingRule.MaskType.PARTIAL, null).setPreserveLeft(1).setPreserveRight(0).setMaskChar('*');
    }

    public static RichTextMaskingRule createUrlRule(String replacement) {
        return new RichTextMaskingRule("\u7f51\u5740", "https?://[\\w.-]+(?:/[\\w.-]*)*", RichTextMaskingRule.MaskType.REPLACE, replacement);
    }

    public static RichTextMaskingRule createSensitiveWordRule(String pattern) {
        return new RichTextMaskingRule("\u654f\u611f\u8bcd", pattern, RichTextMaskingRule.MaskType.FULL, null).setMaskChar('*');
    }

    public static RichTextMaskingRule createCustomRule(String name, String pattern, RichTextMaskingRule.MaskType maskType, String replacement) {
        return new RichTextMaskingRule(name, pattern, maskType, replacement);
    }

    public static RichTextMaskingRule createPartialMaskRule(String name, String pattern, int preserveLeft, int preserveRight, char maskChar) {
        return new RichTextMaskingRule(name, pattern, preserveLeft, preserveRight, maskChar);
    }
}

