/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data.id;

import org.dromara.hutool.core.data.id.IdConstants;
import org.dromara.hutool.core.data.id.NanoId;
import org.dromara.hutool.core.data.id.ObjectId;
import org.dromara.hutool.core.data.id.SeataSnowflake;
import org.dromara.hutool.core.data.id.Snowflake;
import org.dromara.hutool.core.data.id.UUID;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.net.Ipv4Util;
import org.dromara.hutool.core.util.RuntimeUtil;

public class IdUtil {
    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String simpleUUID() {
        return UUID.randomUUID().toString(true);
    }

    public static String fastUUID() {
        return UUID.fastUUID().toString();
    }

    public static String fastSimpleUUID() {
        return UUID.fastUUID().toString(true);
    }

    public static String randomUUID7() {
        return UUID.randomUUID7().toString();
    }

    public static String objectId() {
        return ObjectId.next();
    }

    public static Snowflake getSnowflake(long workerId, long datacenterId) {
        return Singleton.get(Snowflake.class, workerId, datacenterId);
    }

    public static Snowflake getSnowflake(long workerId) {
        return Singleton.get(Snowflake.class, workerId);
    }

    public static Snowflake getSnowflake() {
        return IdConstants.DEFAULT_SNOWFLAKE;
    }

    public static long getSnowflakeNextId() {
        return IdUtil.getSnowflake().next();
    }

    public static String getSnowflakeNextIdStr() {
        return IdUtil.getSnowflake().nextStr();
    }

    public static String nanoId() {
        return NanoId.randomNanoId();
    }

    public static String nanoId(int size) {
        return NanoId.randomNanoId(size);
    }

    public static long getDataCenterId(long maxDatacenterId) {
        Assert.isTrue(maxDatacenterId > 0L, "maxDatacenterId must be > 0", new Object[0]);
        if (maxDatacenterId == Long.MAX_VALUE) {
            --maxDatacenterId;
        }
        long id = 1L;
        byte[] mac = null;
        try {
            mac = Ipv4Util.getLocalHardwareAddress();
        }
        catch (HutoolException hutoolException) {
            // empty catch block
        }
        if (null != mac) {
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= maxDatacenterId + 1L;
        }
        return id;
    }

    public static long getWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        try {
            mpid.append(RuntimeUtil.getPid());
        }
        catch (HutoolException hutoolException) {
            // empty catch block
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static SeataSnowflake getSeataSnowflake() {
        return IdConstants.DEFAULT_SEATA_SNOWFLAKE;
    }

    public static SeataSnowflake getSeataSnowflake(long nodeId) {
        return Singleton.get(SeataSnowflake.class, nodeId);
    }

    public static long getSeataSnowflakeNextId() {
        return IdUtil.getSeataSnowflake().next();
    }

    public static String getSeataSnowflakeNextIdStr() {
        return IdUtil.getSeataSnowflake().nextStr();
    }
}

