/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data.masking;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dromara.hutool.core.data.masking.RichTextMaskingRule;
import org.dromara.hutool.core.text.StrUtil;

public class RichTextMaskingProcessor {
    private final List<RichTextMaskingRule> rules = new ArrayList<RichTextMaskingRule>();
    private boolean preserveHtmlTags = true;

    public RichTextMaskingProcessor() {
    }

    public RichTextMaskingProcessor(boolean preserveHtmlTags) {
        this.preserveHtmlTags = preserveHtmlTags;
    }

    public RichTextMaskingProcessor addRule(RichTextMaskingRule rule) {
        this.rules.add(rule);
        return this;
    }

    public String mask(String text) {
        if (StrUtil.isBlank(text)) {
            return text;
        }
        if (this.preserveHtmlTags && this.isHtmlContent(text)) {
            return this.maskHtmlContent(text);
        }
        return this.maskPlainText(text);
    }

    private boolean isHtmlContent(String text) {
        return text.contains("<") && text.contains(">") && (text.contains("</") || text.contains("/>"));
    }

    private String maskHtmlContent(String html) {
        StringBuilder result = new StringBuilder();
        int lastIndex = 0;
        boolean inTag = false;
        String currentTag = null;
        for (int i = 0; i < html.length(); ++i) {
            char c = html.charAt(i);
            if (c == '<') {
                int tagNameEnd;
                if (!inTag && i > lastIndex) {
                    String textContent = html.substring(lastIndex, i);
                    result.append(this.processTextContentWithContext(textContent, currentTag));
                }
                inTag = true;
                lastIndex = i;
                int tagNameStart = i + 1;
                if (tagNameStart >= html.length()) continue;
                if (html.charAt(tagNameStart) == '/') {
                    ++tagNameStart;
                }
                if ((tagNameEnd = html.indexOf(32, tagNameStart)) == -1) {
                    tagNameEnd = html.indexOf(62, tagNameStart);
                }
                if (tagNameEnd <= tagNameStart) continue;
                currentTag = html.substring(tagNameStart, tagNameEnd).toLowerCase();
                continue;
            }
            if (c != '>' || !inTag) continue;
            inTag = false;
            result.append(html, lastIndex, i + 1);
            lastIndex = i + 1;
        }
        if (lastIndex < html.length()) {
            if (inTag) {
                result.append(html.substring(lastIndex));
            } else {
                String textContent = html.substring(lastIndex);
                result.append(this.processTextContentWithContext(textContent, currentTag));
            }
        }
        return result.toString();
    }

    private String processTextContentWithContext(String text, String tagName) {
        if (StrUtil.isBlank(text)) {
            return text;
        }
        String result = text;
        for (RichTextMaskingRule rule : this.rules) {
            if (tagName != null && (!rule.getIncludeTags().isEmpty() && !rule.getIncludeTags().contains(tagName) || rule.getExcludeTags().contains(tagName))) continue;
            result = this.applyMaskingRule(result, rule);
        }
        return result;
    }

    private String maskPlainText(String text) {
        String result = text;
        for (RichTextMaskingRule rule : this.rules) {
            result = this.applyMaskingRule(result, rule);
        }
        return result;
    }

    private String applyMaskingRule(String text, RichTextMaskingRule rule) {
        if (StrUtil.isBlank(text) || StrUtil.isBlank(rule.getPattern())) {
            return text;
        }
        Pattern pattern = Pattern.compile(rule.getPattern());
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String matched = matcher.group();
            switch (rule.getMaskType()) {
                case FULL: {
                    replacement = StrUtil.repeat(rule.getMaskChar(), matched.length());
                    break;
                }
                case PARTIAL: {
                    replacement = this.partialMask(matched, rule.getPreserveLeft(), rule.getPreserveRight(), rule.getMaskChar());
                    break;
                }
                case REPLACE: {
                    replacement = rule.getReplacement();
                    break;
                }
                default: {
                    replacement = matched;
                }
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String partialMask(String text, int preserveLeft, int preserveRight, char maskChar) {
        if (StrUtil.isBlank(text)) {
            return text;
        }
        int length = text.length();
        int maskLength = length - (preserveLeft = Math.min(preserveLeft, length)) - (preserveRight = Math.min(preserveRight, length - preserveLeft));
        if (maskLength <= 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(length);
        if (preserveLeft > 0) {
            sb.append(text, 0, preserveLeft);
        }
        sb.append(StrUtil.repeat(maskChar, maskLength));
        if (preserveRight > 0) {
            sb.append(text, length - preserveRight, length);
        }
        return sb.toString();
    }
}

