/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;

public class SerializeUtil {
    public static <T> T clone(T obj) {
        if (!(obj instanceof Serializable)) {
            return null;
        }
        return SerializeUtil.deserialize(SerializeUtil.serialize(obj), new Class[0]);
    }

    public static <T> byte[] serialize(T obj) {
        if (!(obj instanceof Serializable)) {
            return null;
        }
        FastByteArrayOutputStream byteOut = new FastByteArrayOutputStream();
        IoUtil.writeObjects(byteOut, false, obj);
        return byteOut.toByteArray();
    }

    public static <T> T deserialize(byte[] bytes, Class<?> ... acceptClasses) {
        return IoUtil.readObj(new ByteArrayInputStream(bytes), acceptClasses);
    }
}

