/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.buffer.FastByteBuffer;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class FastByteArrayOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public static FastByteArrayOutputStream of(InputStream in, int limit) {
        int length = IoUtil.length(in);
        if (length < 0 || length > limit) {
            length = limit;
        }
        if (length < 0) {
            length = 8192;
        }
        return new FastByteArrayOutputStream(length);
    }

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((byte)b);
    }

    public int size() {
        return this.buffer.length();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.buffer.reset();
    }

    public void writeTo(OutputStream out) throws IORuntimeException {
        int index = this.buffer.index();
        if (index < 0) {
            return;
        }
        try {
            for (int i = 0; i < index; ++i) {
                byte[] buf = this.buffer.array(i);
                out.write(buf);
            }
            out.write(this.buffer.array(index), 0, this.buffer.offset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public byte[] toByteArray(int start, int len) {
        return this.buffer.toArray(start, len);
    }

    public byte[] toByteArrayZeroCopyIfPossible() {
        return this.buffer.toArrayZeroCopyIfPossible();
    }

    public String toString() {
        return this.toString(CharsetUtil.defaultCharset());
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), ObjUtil.defaultIfNull(charset, CharsetUtil::defaultCharset));
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }
}

