/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.dromara.hutool.core.collection.iter.ComputeIter;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.buffer.FastByteBuffer;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class LineInputStream
extends FilterInputStream
implements Iterable<byte[]> {
    public LineInputStream(InputStream in) {
        super(in);
    }

    public String readLine(Charset charset) throws IORuntimeException {
        return StrUtil.str(this.readLine(), charset);
    }

    public byte[] readLine() throws IORuntimeException {
        try {
            return this._readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new ComputeIter<byte[]>(){

            @Override
            protected byte[] computeNext() {
                return LineInputStream.this.readLine();
            }
        };
    }

    private byte[] _readLine() throws IOException {
        int c;
        FastByteBuffer out = null;
        boolean precedingBackslash = false;
        while ((c = this.read()) > 0) {
            if (null == out) {
                out = new FastByteBuffer();
            }
            if (92 == c) {
                if (!precedingBackslash) {
                    precedingBackslash = true;
                    continue;
                }
                precedingBackslash = false;
            } else if (precedingBackslash) {
                if (CharUtil.isBlankChar(c)) continue;
                precedingBackslash = false;
            } else if (10 == c) {
                int lastIndex = out.length() - 1;
                if (lastIndex < 0 || 13 != out.get(lastIndex)) break;
                return out.toArray(0, lastIndex);
            }
            out.append((byte)c);
        }
        return ObjUtil.apply(out, FastByteBuffer::toArray);
    }
}

