/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class UTF8OutputStreamWriter
extends Writer {
    private final OutputStream out;
    int lastUTF16CodePoint = 0;

    public UTF8OutputStreamWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            int uc = ((this.lastUTF16CodePoint & 0x3FF) << 10 | c & 0x3FF) + 65536;
            this.out.write(0xF0 | uc >> 18);
            this.out.write(0x80 | uc >> 12 & 0x3F);
            this.out.write(0x80 | uc >> 6 & 0x3F);
            this.out.write(0x80 | uc & 0x3F);
            this.lastUTF16CodePoint = 0;
            return;
        }
        if (c < 128) {
            this.out.write(c);
        } else if (c < 2048) {
            this.out.write(0xC0 | c >> 6);
            this.out.write(0x80 | c & 0x3F);
        } else if (c <= 65535) {
            if (!UTF8OutputStreamWriter.isHighSurrogate(c) && !UTF8OutputStreamWriter.isLowSurrogate(c)) {
                this.out.write(0xE0 | c >> 12);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0x80 | c & 0x3F);
            } else {
                this.lastUTF16CodePoint = c;
            }
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        for (int i = 0; i < cbuf.length; ++i) {
            this.write(cbuf[i]);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(cbuf[off + i]);
        }
    }

    @Override
    public void write(String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.write(str.charAt(i));
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(str.charAt(off + i));
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            throw new IllegalStateException("Attempting to close a UTF8OutputStreamWriter while awaiting for a UTF-16 code unit");
        }
        this.out.close();
    }

    private static boolean isHighSurrogate(int c) {
        return 55296 <= c && c <= 56319;
    }

    private static boolean isLowSurrogate(int c) {
        return 56320 <= c && c <= 57343;
    }
}

