/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.range;

import java.util.Objects;
import java.util.function.Predicate;
import org.dromara.hutool.core.lang.range.BoundType;
import org.dromara.hutool.core.lang.range.BoundedRange;
import org.dromara.hutool.core.lang.range.FiniteBound;
import org.dromara.hutool.core.lang.range.NoneLowerBound;
import org.dromara.hutool.core.lang.range.NoneUpperBound;

public interface Bound<T extends Comparable<? super T>>
extends Predicate<T>,
Comparable<Bound<T>> {
    public static final String INFINITE_MIN = "-\u221e";
    public static final String INFINITE_MAX = "+\u221e";

    public static <T extends Comparable<? super T>> Bound<T> noneLowerBound() {
        return NoneLowerBound.INSTANCE;
    }

    public static <T extends Comparable<? super T>> Bound<T> noneUpperBound() {
        return NoneUpperBound.INSTANCE;
    }

    public static <T extends Comparable<? super T>> Bound<T> greaterThan(T min) {
        return new FiniteBound<T>(Objects.requireNonNull(min), BoundType.OPEN_LOWER_BOUND);
    }

    public static <T extends Comparable<? super T>> Bound<T> atLeast(T min) {
        return new FiniteBound<T>(Objects.requireNonNull(min), BoundType.CLOSE_LOWER_BOUND);
    }

    public static <T extends Comparable<? super T>> Bound<T> lessThan(T max) {
        return new FiniteBound<T>(Objects.requireNonNull(max), BoundType.OPEN_UPPER_BOUND);
    }

    public static <T extends Comparable<? super T>> Bound<T> atMost(T max) {
        return new FiniteBound<T>(Objects.requireNonNull(max), BoundType.CLOSE_UPPER_BOUND);
    }

    public T getValue();

    public BoundType getType();

    @Override
    public boolean test(T var1);

    @Override
    public int compareTo(Bound<T> var1);

    public String descBound();

    @Override
    public Bound<T> negate();

    public BoundedRange<T> toRange();

    public String toString();
}

