/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.selector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.selector.Selector;
import org.dromara.hutool.core.lang.selector.WeightObj;
import org.dromara.hutool.core.util.ObjUtil;

public class WeightListRandomSelector<E>
implements Selector<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<WeightObj<E>> randomPool;

    public WeightListRandomSelector() {
        this.randomPool = new ArrayList<WeightObj<E>>();
    }

    public WeightListRandomSelector(int poolSize) {
        this.randomPool = new ArrayList<WeightObj<E>>(poolSize);
    }

    public void add(E e, int weight) {
        Assert.isTrue(weight > 0, "\u6743\u91cd\u5fc5\u987b\u5927\u4e8e0\uff01", new Object[0]);
        this.randomPool.add(new WeightObj<E>(e, this.sumWeight() + weight));
    }

    public boolean remove(E e) {
        boolean removed = false;
        int weight = 0;
        int i = 0;
        Iterator<WeightObj<E>> iterator = this.randomPool.iterator();
        while (iterator.hasNext()) {
            WeightObj<E> ew = iterator.next();
            if (!removed && ObjUtil.equals(ew.obj, e)) {
                iterator.remove();
                weight = ew.weight - (i == 0 ? 0 : this.randomPool.get((int)(i - 1)).weight);
                removed = true;
            }
            if (removed) {
                ew.weight -= weight;
            }
            ++i;
        }
        return removed;
    }

    public boolean isEmpty() {
        return this.randomPool.isEmpty();
    }

    @Override
    public E select() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.randomPool.size() == 1) {
            return (E)this.randomPool.get((int)0).obj;
        }
        return this.binarySearch((int)((double)this.sumWeight() * Math.random()));
    }

    private E binarySearch(int randomWeight) {
        int low = 0;
        int high = this.randomPool.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midWeight = this.randomPool.get((int)mid).weight;
            if (midWeight < randomWeight) {
                low = mid + 1;
                continue;
            }
            if (midWeight > randomWeight) {
                high = mid - 1;
                continue;
            }
            return (E)this.randomPool.get((int)mid).obj;
        }
        return (E)this.randomPool.get((int)low).obj;
    }

    private int sumWeight() {
        if (this.randomPool.isEmpty()) {
            return 0;
        }
        return this.randomPool.get((int)(this.randomPool.size() - 1)).weight;
    }
}

