/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.ssl;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.net.ssl.KeyManagerUtil;
import org.dromara.hutool.core.net.ssl.SSLContextBuilder;
import org.dromara.hutool.core.net.ssl.TrustManagerUtil;

public class SSLContextUtil {
    public static SSLContext getDefault() {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new HutoolException(e);
        }
    }

    public static SSLContext createTrustAnySSLContext() throws IORuntimeException {
        return SSLContextUtil.createTrustAnySSLContext(null);
    }

    public static SSLContext createTrustAnySSLContext(String protocol) throws IORuntimeException {
        return SSLContextBuilder.of().setProtocol(protocol).setTrustManagers(TrustManagerUtil.TRUST_ANYS).build();
    }

    public static SSLContext createSSLContext(String protocol, KeyManager keyManager, TrustManager trustManager) throws IORuntimeException {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        if (keyManager == null) {
            keyManagerArray = null;
        } else {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = keyManager;
        }
        if (trustManager == null) {
            trustManagerArray = null;
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = trustManager;
        }
        return SSLContextUtil.createSSLContext(protocol, keyManagerArray, trustManagerArray);
    }

    public static SSLContext createSSLContext(KeyStore keyStore, char[] password) throws IORuntimeException {
        return SSLContextUtil.createSSLContext(KeyManagerUtil.getKeyManagers(keyStore, password), TrustManagerUtil.getTrustManagers(keyStore));
    }

    public static SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws IORuntimeException {
        return SSLContextUtil.createSSLContext(null, keyManagers, trustManagers);
    }

    public static SSLContext createSSLContext(String protocol, KeyManager[] keyManagers, TrustManager[] trustManagers) throws IORuntimeException {
        return SSLContextBuilder.of().setProtocol(protocol).setKeyManagers(keyManagers).setTrustManagers(trustManagers).build();
    }
}

