/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.method;

import java.beans.Introspector;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;

public class MethodNameUtil {
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";

    public static String decapitalize(CharSequence name) {
        return Introspector.decapitalize(StrUtil.toStringOrNull(name));
    }

    public static String getGeneralField(CharSequence getOrSetMethodName) {
        Assert.notBlank(getOrSetMethodName);
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith(GET_PREFIX) || getOrSetMethodNameStr.startsWith(SET_PREFIX)) {
            return StrUtil.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        if (getOrSetMethodNameStr.startsWith(IS_PREFIX)) {
            return StrUtil.removePreAndLowerFirst(getOrSetMethodName, 2);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, SET_PREFIX);
    }

    public static String genGetter(CharSequence fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, GET_PREFIX);
    }
}

