/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text;

import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.CharUtil;

public class StrValidator {
    public static final String NULL = "null";
    public static final String EMPTY = "";

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StrValidator.isEmpty(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        return ArrayUtil.hasBlank(strs);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return ArrayUtil.isAllNotBlank(args);
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        return ArrayUtil.isAllBlank(strs);
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrValidator.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEmpty(Iterable<? extends CharSequence> strs) {
        if (CollUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence charSequence : strs) {
            if (!StrValidator.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayUtil.isNotEmpty(strs)) {
            for (CharSequence str : strs) {
                if (!StrValidator.isNotEmpty(str)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllEmpty(Iterable<? extends CharSequence> strs) {
        if (CollUtil.isNotEmpty(strs)) {
            for (CharSequence charSequence : strs) {
                if (!StrValidator.isNotEmpty(charSequence)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return !StrValidator.hasEmpty(args);
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        if (null == str) {
            return true;
        }
        return StrValidator.isNullOrUndefinedStr(str);
    }

    public static boolean isEmptyOrUndefined(CharSequence str) {
        if (StrValidator.isEmpty(str)) {
            return true;
        }
        return StrValidator.isNullOrUndefinedStr(str);
    }

    public static boolean isBlankOrUndefined(CharSequence str) {
        if (StrValidator.isBlank(str)) {
            return true;
        }
        return StrValidator.isNullOrUndefinedStr(str);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return NULL.equals(strString) || "undefined".equals(strString);
    }

    public static boolean isAllCharMatch(CharSequence value, Predicate<Character> matcher) {
        if (StrValidator.isBlank(value)) {
            return false;
        }
        int i = value.length();
        while (--i >= 0) {
            if (matcher.test(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }
}

