/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.util;

import java.util.Properties;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.util.BooleanUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class SystemUtil {
    public static final String HUTOOL_DATE_LENIENT = "hutool.date.lenient";

    public static String get(String name, String defaultValue) {
        return ObjUtil.defaultIfNull(SystemUtil.get(name), defaultValue);
    }

    public static String get(String key) {
        return SystemUtil.get(key, false);
    }

    public static String getQuietly(String key) {
        return SystemUtil.get(key, true);
    }

    public static String get(String name, boolean quiet) {
        String value;
        block6: {
            block5: {
                value = null;
                try {
                    value = System.getProperty(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block5;
                    Console.error("Caught a SecurityException reading the system property '{}'; the SystemUtil property value will default to null.", name);
                }
            }
            if (null == value) {
                try {
                    value = System.getenv(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block6;
                    Console.error("Caught a SecurityException reading the system env '{}'; the SystemUtil env value will default to null.", name);
                }
            }
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = SystemUtil.get(key);
        if (value == null) {
            return defaultValue;
        }
        return BooleanUtil.toBoolean(value);
    }

    public static int getInt(String key, int defaultValue) {
        return ConvertUtil.toInt(SystemUtil.get(key), defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        return ConvertUtil.toLong(SystemUtil.get(key), defaultValue);
    }

    public static Properties getProps() {
        return System.getProperties();
    }

    public static void set(String key, String value) {
        if (null == value) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    public static String[] getJavaClassPaths() {
        return SystemUtil.get("java.class.path").split(SystemUtil.get("path.separator"));
    }

    public static String getUserHomePath() {
        return SystemUtil.get("user.home");
    }

    public static String getTmpDirPath() {
        return SystemUtil.get("java.io.tmpdir");
    }

    public static String getUserDirPath() {
        return SystemUtil.get("user.dir");
    }
}

