/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.pooled;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.pool.ObjectFactory;
import org.dromara.hutool.core.pool.ObjectPool;
import org.dromara.hutool.core.pool.partition.PartitionObjectPool;
import org.dromara.hutool.core.pool.partition.PartitionPoolConfig;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.db.ds.pooled.PooledConnection;
import org.dromara.hutool.db.ds.simple.AbstractDataSource;
import org.dromara.hutool.log.LogUtil;
import org.dromara.hutool.setting.props.Props;

public class PooledDataSource
extends AbstractDataSource {
    private static final String KEY_MAX_WAIT = "maxWait";
    private static final String KEY_INITIAL_SIZE = "initialSize";
    private static final String KEY_MAX_ACTIVE = "maxActive";
    private static final String KEY_MAX_IDLE = "maxIdle";
    protected Driver driver;
    private final int maxWait;
    private final ObjectPool<PooledConnection> connPool;

    public PooledDataSource(ConnectionConfig<?> config) {
        String driverName = config.getDriver();
        if (StrUtil.isNotBlank(driverName)) {
            this.driver = DriverUtil.createDriver(driverName);
        }
        Props poolProps = Props.of(config.getPoolProps());
        this.maxWait = poolProps.getInt(KEY_MAX_WAIT, 6000);
        PartitionPoolConfig poolConfig = (PartitionPoolConfig)PartitionPoolConfig.of().setPartitionSize(1).setMaxWait(this.maxWait).setMinSize(poolProps.getInt(KEY_INITIAL_SIZE, 0)).setMaxSize(poolProps.getInt(KEY_MAX_ACTIVE, 8)).setMaxIdle(poolProps.getInt(KEY_MAX_IDLE, 0).intValue());
        this.connPool = new PartitionObjectPool<PooledConnection>(poolConfig, this.createConnFactory(config));
    }

    public PooledDataSource setDriver(Driver driver) {
        this.driver = driver;
        return this;
    }

    @Override
    public PooledConnection getConnection() throws SQLException {
        return this.connPool.borrowObject().open();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Pooled DataSource is not allow to get special Connection!");
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(this.connPool);
    }

    public void returnObject(PooledConnection conn) {
        this.connPool.returnObject(conn);
    }

    private ObjectFactory<PooledConnection> createConnFactory(final ConnectionConfig<?> config) {
        return new ObjectFactory<PooledConnection>(){

            @Override
            public PooledConnection create() {
                return new PooledConnection(config, PooledDataSource.this);
            }

            @Override
            public boolean validate(PooledConnection connection) {
                try {
                    return null != connection && connection.isValid(PooledDataSource.this.maxWait);
                }
                catch (SQLException e) {
                    LogUtil.error(e);
                    return false;
                }
            }

            @Override
            public void destroy(PooledConnection connection) {
                if (null != connection) {
                    connection.destroy();
                }
            }
        };
    }
}

