/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mq.engine.rocketmq;

import java.io.IOException;
import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.dromara.hutool.extra.mq.Consumer;
import org.dromara.hutool.extra.mq.MQException;
import org.dromara.hutool.extra.mq.Message;
import org.dromara.hutool.extra.mq.MessageHandler;

public class RocketMQConsumer
implements Consumer {
    private final MQPushConsumer consumer;

    public RocketMQConsumer(MQPushConsumer consumer) {
        this.consumer = consumer;
    }

    public RocketMQConsumer setTopic(String topic) {
        try {
            this.consumer.subscribe(topic, "*");
        }
        catch (MQClientException e) {
            throw new MQException(e);
        }
        return this;
    }

    @Override
    public void subscribe(MessageHandler messageHandler) {
        this.consumer.registerMessageListener((msgs, context) -> {
            for (MessageExt msg : msgs) {
                messageHandler.handle(new RocketMQMessage(msg));
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        });
    }

    @Override
    public void close() throws IOException {
        if (null != this.consumer) {
            this.consumer.shutdown();
        }
    }

    private static class RocketMQMessage
    implements Message {
        private final MessageExt messageExt;

        private RocketMQMessage(MessageExt messageExt) {
            this.messageExt = messageExt;
        }

        @Override
        public String topic() {
            return this.messageExt.getTopic();
        }

        @Override
        public byte[] content() {
            return this.messageExt.getBody();
        }
    }
}

