/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.httpclient4;

import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.http.ssl.SSLInfo;

public class ConnectionSocketFactoryRegistryBuilder
implements Builder<Registry<ConnectionSocketFactory>> {
    private static final long serialVersionUID = 1L;
    private final RegistryBuilder<ConnectionSocketFactory> builder = RegistryBuilder.create();

    public static ConnectionSocketFactoryRegistryBuilder of() {
        return new ConnectionSocketFactoryRegistryBuilder();
    }

    public static Registry<ConnectionSocketFactory> build(SSLInfo sslInfo) {
        return ConnectionSocketFactoryRegistryBuilder.of().registerPlainHttp().registerHttps(sslInfo).build();
    }

    public ConnectionSocketFactoryRegistryBuilder registerPlainHttp() {
        return this.registerHttp((ConnectionSocketFactory)PlainConnectionSocketFactory.getSocketFactory());
    }

    public ConnectionSocketFactoryRegistryBuilder registerHttp(ConnectionSocketFactory socketFactory) {
        return this.register("http", socketFactory);
    }

    public ConnectionSocketFactoryRegistryBuilder registerHttps(SSLInfo sslInfo) {
        return this.register("https", (ConnectionSocketFactory)ConnectionSocketFactoryRegistryBuilder.buildSocketFactory(sslInfo));
    }

    public ConnectionSocketFactoryRegistryBuilder register(String protocol, ConnectionSocketFactory socketFactory) {
        this.builder.register(protocol, (Object)socketFactory);
        return this;
    }

    @Override
    public Registry<ConnectionSocketFactory> build() {
        return this.builder.build();
    }

    private static SSLConnectionSocketFactory buildSocketFactory(SSLInfo sslInfo) {
        if (null == sslInfo) {
            return SSLConnectionSocketFactory.getSocketFactory();
        }
        return new SSLConnectionSocketFactory(sslInfo.getSslContext(), sslInfo.getProtocols(), null, sslInfo.getHostnameVerifier());
    }
}

